package com.example.twolibs.TimeTableGUI;


import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableBL.TTStop;

import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;
import android.view.View;
import android.view.View.OnClickListener;


public class LegDetails  extends ListActivity {
	
	ArrayList<JourneySupport> list = new ArrayList<>();
	LegListAdaptor adapter;
	
	boolean includeStops = false;
	ListView listview;


    
	 public void onCreate(Bundle savedInstanceState)
	   {
	      super.onCreate(savedInstanceState);
	      
	      setContentView(R.layout.activity_leglist);
	      setTitle(" Journey details");
	      
	      final AppContext bb  = (AppContext)getApplicationContext();
	      TTJourney jny = bb.selJourney;

	      JourneySupport jsl;
	      JourneySupport jss;
	    	for(TTLeg objLeg : jny.getJy_legs()){
	    		jsl = new JourneySupport();
	    		jsl.eventType = 0;
	    		jsl.leg = objLeg;
	    		list.add(jsl);
	       	
	    		if (includeStops) {
		         	for(TTStop objStop : objLeg.getPassstops()){
			          	jss = new JourneySupport();
			           	jss.eventType = 2;
			           	jss.stop = objStop;
			           	list.add(jss);
	
		         	}
	    		}
	         	
	    		jsl = new JourneySupport();
	    		jsl.eventType = 1;
	    		jsl.leg = objLeg;
	    		list.add(jsl);
	         	
	     	} 

          listview = findViewById(android.R.id.list);

          adapter = new LegListAdaptor(this,list,bb);
          setListAdapter(adapter);
          getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

   
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

          @Override
          public void onItemClick(AdapterView<?> parent, final View view,
              int position, long id) {
          	
 
              for (int j = 0; j < parent.getChildCount(); j++)
              	parent.getChildAt(j).setBackgroundColor(Color.TRANSPARENT);

              // change the background color of the selected element
              view.setBackgroundColor(Color.LTGRAY);

               
          }

        });
        
 
        // setup callbacks
        Button cmdEarlier = findViewById(R.id.cmdEarlier);
        cmdEarlier.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

        	Toast.makeText(LegDetails.this, "Earlier  Clicked", Toast.LENGTH_SHORT).show();  
 
        	} 
        });
        

        Button cmdLater = findViewById(R.id.cmdLater);
        cmdLater.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

        	Toast.makeText(LegDetails.this, "Later  Clicked", Toast.LENGTH_SHORT).show();  
 
        	} 
        });
        
        Button cmdDone = findViewById(R.id.cmdDone);
        cmdDone.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

         	Intent returnIntent = new Intent();
           	returnIntent.putExtra("result",-1);

        	setResult(RESULT_OK);
			  
        	finish();
        	 
        	}
        });       

        
        Button cmdStops = findViewById(R.id.cmdStops);
        cmdStops.setOnClickListener(new OnClickListener() {  

        	public void onClick(View view) {  

        		includeStops = !includeStops;
        		Button cmdStops = findViewById(R.id.cmdStops);
	        	if(includeStops)	{
	        		cmdStops.setText("Legs");
	        	} else {
	        		cmdStops.setText("Legs");
	        	}
	        		
	            adapter.clear();
	            list = new ArrayList<>();
	            TTJourney jny = bb.selJourney;
	           
	   	        JourneySupport jsl;
		        JourneySupport jss;
		    	for(TTLeg objLeg : jny.getJy_legs()){
		    		jsl = new JourneySupport();
		    		jsl.eventType = 0;
		    		jsl.leg = objLeg;
		    		list.add(jsl);
		       	
	        		if (includeStops) {
		   	         	for(TTStop objStop : objLeg.getPassstops()){
	    		          	jss = new JourneySupport();
	    		           	jss.eventType = 2;
	    		           	jss.stop = objStop;
							if (objStop.getPse_type() != 3) { // JM 4/9/2017
							    list.add(jss);
							}
	
	    	         	}
	        		}
	         	
		    		jsl = new JourneySupport();
		    		jsl.eventType = 1;
		    		jsl.leg = objLeg;
		    		list.add(jsl);
	         	
		    	} 
	    	
	            adapter.addAll(list);
	            adapter.notifyDataSetChanged();
                
			} 
        	
        	
        });  
	        
	   }

/*
 * 		@Override(non-Javadoc)
 * @see android.app.Activity#onActivityResult(int, int, android.content.Intent)
 */
/*		protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		    if (requestCode == 1) {
		        if(resultCode == RESULT_OK){
		        	Location origin = (Location) data.getSerializableExtra("result");
		            
		         	BlackBoard bb  = (BlackBoard)getApplicationContext();
		         	bb.setOrigin(origin);

					TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
					txtOrigin.setText(origin.strDescription );
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 2) {
		        if(resultCode == RESULT_OK){
		        	Location destination = (Location) data.getSerializableExtra("result");

		         	BlackBoard bb  = (BlackBoard)getApplicationContext();
		         	bb.setDestination(destination);
		            
		         	TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
		         	txtDestination.setText(destination.strDescription );
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 3) {
		        if(resultCode == RESULT_OK){
		        	// Journey selected?
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    

		}

	*/	

}
