package com.example.twolibs.TimeTableGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableBL.TTStop;

import android.app.Activity;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;


public class LegListAdaptor extends ArrayAdapter<JourneySupport> {
	private final Activity context;
	private final ArrayList<JourneySupport> legList;
	private final AppContext bb;


	
	static class ViewHolder {
		public TextView txtDepartTime;
		public TextView txtArriveDesc;
		public TextView txtDepartDesc;
		public TextView txtLocation;
		public TextView txtArriveTime;
		public int	position;
	}
	
	public LegListAdaptor(Activity context,ArrayList<JourneySupport> legList, AppContext bb) {
	  super(context, R.layout.leg_summary, legList);
	  this.context = context;
	  this.legList = legList;
	  this.bb = bb;
	}

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (context.getResources().getColor(Color, TH));
		}else{
			return (context.getResources().getColor(Color));
		}
	}


	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
	  View rowView = convertView;
	  String crsCode;
	  String txtLocation; 	
  	
	  // reuse views
	  if (rowView == null) {
	    LayoutInflater inflater = context.getLayoutInflater();
	    rowView = inflater.inflate(R.layout.leg_summary, null);
	    // configure view holder
	    ViewHolder viewHolder = new ViewHolder();
	    viewHolder.txtDepartTime = (TextView) rowView.findViewById(R.id.txtDepartTime);
	    viewHolder.txtArriveDesc = (TextView) rowView.findViewById(R.id.txtArriveDesc);
	    viewHolder.txtDepartDesc = (TextView) rowView.findViewById(R.id.txtDepartDesc);
	    viewHolder.txtLocation = (TextView) rowView.findViewById(R.id.txtLocation);
	    viewHolder.txtArriveTime = (TextView) rowView.findViewById(R.id.txtArriveTime);

	    rowView.setTag(viewHolder);
	  }
	
	  ViewHolder holder = (ViewHolder) rowView.getTag();	  
	 
	  
	  // fill data
	  Location loc;
	  holder.position = position;
	  JourneySupport js = legList.get(position);
	  if (js.eventType < 2){
		  // Leg details
		  TTLeg l =js.leg;
		  holder.txtDepartTime.setPadding(0, 0, 0, 0);
		  
		  if(js.eventType == 0){
			  // Leg origin
			  holder.txtArriveDesc.setText("");
			  holder.txtDepartDesc.setText("Depart: ");

			  holder.txtDepartTime.setText(l.getLeg_departsTime());
			  
			  crsCode = l.getLeg_origin();
			  loc = Location.getLocationByCRS(crsCode);
			  if(loc != null){
				  txtLocation = loc.getDescription();
			  } else {
				  txtLocation = crsCode;
			  }
			  
			  holder.txtLocation.setText(txtLocation);
			  holder.txtArriveTime.setText("");		  
		  } else {
			  // leg destination
			  holder.txtArriveDesc.setText("");
			  holder.txtDepartDesc.setText("Arrive: ");
			  
			  holder.txtDepartTime.setText("");
			  
			  crsCode = l.getLeg_destination();
			  loc = Location.getLocationByCRS(crsCode);
			  if(loc != null){
				  txtLocation = loc.getDescription();
			  } else {
				  txtLocation = crsCode;
			  }
			  holder.txtLocation.setText(txtLocation);		  
			  holder.txtArriveTime.setText(l.getLeg_arrivesTime());	
		  }  
	
		  
	  } else {
		  TTStop s =js.stop;
		  // Stop details
		  holder.txtArriveDesc.setText("");
		  holder.txtDepartDesc.setText("");
		  
		  String strTime = s.getPse_arrives();
		  strTime = strTime.subSequence(0, 2) + ":" + strTime.subSequence(2,4);
		  holder.txtDepartTime.setText(strTime);
		  holder.txtDepartTime.setPadding(40, 0, 0, 0);
		  holder.txtDepartTime.setTextColor(JMgetColor(R.color.fj_grey_2, context.getTheme()));
		  
		  crsCode = s.getPse_station();
		  loc = Location.getLocationByCRS(crsCode);
		  if(loc != null){
			  txtLocation = loc.getDescription();
		  } else {
			  txtLocation = crsCode;
		  }
		  holder.txtLocation.setText(txtLocation);
		  holder.txtLocation.setPadding(40, 0, 0, 0);
			  holder.txtArriveTime.setText("");

		  }

	  return rowView;
	}

}
