package com.example.twolibs.TimeTableGUI;

import java.util.Date;
import java.util.Locale;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.R.color;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportGUI.ClockPicker;
import com.example.twolibs.TimeTableBL.TTSearch;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.content.DialogInterface;



public class TimeTableCriteria  extends Activity {
	
	Activity activity;
	
	 public void onCreate(Bundle savedInstanceState)
	   {
	      super.onCreate(savedInstanceState);
	      
	      setContentView(R.layout.activity_timetablecriteria);
       	  final AppContext bb  = (AppContext)getApplicationContext();
	      activity = this.getParent();
 
		   setTitle(" Timetable");
		   String locfile;
		   
	        locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/TT.ini";  
	        
	        com.example.twolibs.TimeTableBL.STDResponse ttresp = bb.ttSearch.initialise(locfile);

       	  
	      TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
		  txtOrigin.setText(bb.getOrigin().getDescription());
		  
		  LinearLayout cmdOrigin = (LinearLayout) findViewById(R.id.frmOrigin); 
         	
			cmdOrigin.setOnClickListener(new OnClickListener() {  
			
				public void onClick(View view) {  
			
				//Toast.makeText(MainActivity.this, "Timetable clicked", Toast.LENGTH_SHORT).show();  
				//Starting a new Intent                 
				Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);
				
				//Sending data to another Activity                 
				nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.FROM_SEARCH);
				nextScreen.putExtra("search", "timetable");

				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
		        startActivityForResult(nextScreen, 1);
				//startActivity(nextScreen); 
				}  
				

			}); 
			
			
		      TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
			  txtDestination.setText(bb.getDestination().getDescription());
			  
			  LinearLayout cmdDestination = (LinearLayout) findViewById(R.id.frmDestination); 

			  cmdDestination.setOnClickListener(new OnClickListener() {  
			
				public void onClick(View view) {  
			
				//Toast.makeText(MainActivity.this, "Timetable clicked", Toast.LENGTH_SHORT).show();  
				//Starting a new Intent                 
				Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);                   
				//Sending data to another Activity                 
				nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.TO_SEARCH);
				nextScreen.putExtra("search", "timetable");
				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
				//startActivity(nextScreen); 
		        startActivityForResult(nextScreen, 2);
				}  
			
			}); 

			TextView txtTime = (TextView) findViewById(R.id.txtTimeTT);
			txtTime.setText(DataConvert.displayTextTime(bb.getSearchDate()));
			
			LinearLayout cmdTime = (LinearLayout) findViewById(R.id.frmTime); 
			cmdTime.setOnClickListener(new OnClickListener() {  
			
				public void onClick(View view) {  
			
				//Toast.makeText(MainActivity.this, "Timetable clicked", Toast.LENGTH_SHORT).show();  
				//Starting a new Intent                 
				Intent nextScreen = new Intent(getApplicationContext(), ClockPicker.class);                   
				//Sending data to another Activity                 
				nextScreen.putExtra("direction", "to");
				nextScreen.putExtra("search", "timetable");

				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
				//startActivity(nextScreen); 
		        startActivityForResult(nextScreen, 2);
				}  
			
			}); 


			
			TextView txtDate = (TextView) findViewById(R.id.txtDate);
			txtDate.setText(DataConvert.displayTextDate(bb.getSearchDate()));
			
			LinearLayout cmdDate = (LinearLayout) findViewById(R.id.frmDate); 
			cmdDate.setOnClickListener(new OnClickListener() {  
			
				public void onClick(View view) {  
			
	        		Date searchDate = bb.getSearchDate();
	        	    int year = DataConvert.getYear(searchDate);
					int month = DataConvert.getMonth(searchDate);
					int day = DataConvert.getDayOfMonth(searchDate);
	        	    					
					DatePickerDialog dialog = new DatePickerDialog(TimeTableCriteria.this, datePickerListener, year,month,day);
					dialog.show();

				} 
				
				private DatePickerDialog.OnDateSetListener datePickerListener 
					= new DatePickerDialog.OnDateSetListener() {

			        // when dialog box is closed, below method will be called.
				        public void onDateSet(DatePicker view, int selectedYear,
						            int selectedMonth, int selectedDay) {
						            //Do whatever you want
			        		Date searchDate = bb.getSearchDate();
			        		
			        	    bb.setSearchDate(DataConvert.setDate(searchDate, selectedYear, selectedMonth, selectedDay));
			        		
			    			TextView txtDate = (TextView) findViewById(R.id.txtDate);
			    			txtDate.setText(DataConvert.displayTextDate(bb.getSearchDate()));
			        		
					        }
						};
				}); 
						
			TextView txtChanges = (TextView) findViewById(R.id.txtChanges);
			int changes = bb.getChanges();
			if (changes == 0){
				txtChanges.setText("Direct");
			} else if (changes == 0){
				txtChanges.setText("One change");
			} else {
				txtChanges.setText(changes + " changes");
			}
			
			LinearLayout cmdChanges = (LinearLayout) findViewById(R.id.frmChanges); 
			cmdChanges.setOnClickListener(new OnClickListener() {   
				   @Override
				   public void onClick(View v) {
				    // TODO Auto-generated method stub   
				    final CharSequence[] items = {"Direct", "1", "2", "3", "4", "5", "6"};
				    AlertDialog.Builder listBuilder = new AlertDialog.Builder(TimeTableCriteria.this);
				    listBuilder.setTitle("Changes");
				    listBuilder.setItems(items, new DialogInterface.OnClickListener() {
				       public void onClick(DialogInterface dialog, int item) {
//				           Toast.makeText(getApplicationContext(), items[item], Toast.LENGTH_SHORT).show();
					    	TextView txtChanges = (TextView) findViewById(R.id.txtChanges);
							int changes = item;
							if (changes == 0){
								txtChanges.setText("Direct");
							} else if (changes == 0){
								txtChanges.setText("One change");
							} else {
								txtChanges.setText(changes + " changes");
							}	
							bb.setChanges(changes);
							}
				    });
				    AlertDialog alertList = listBuilder.create();
				    alertList.show();    
				   }
				  }); 

			
			
	        Button cmdSearch = (Button) findViewById(R.id.cmdSearch);
	        cmdSearch.setText("Search");
	        cmdSearch.setOnClickListener(new OnClickListener() {  

	        	public void onClick(View view) {  

	        	//Starting a new Intent                 
                
				Intent nextScreen = new Intent(getApplicationContext(), TwoLibs.class);                   
				//Sending data to another Activity                 
				nextScreen.putExtra("direction", "to");
				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
				//startActivity(nextScreen); 
		        startActivityForResult(nextScreen, 3);
				} 
	        	
	        	
	        }); 
	        
	        /*
			//************************************** Functions *************************************** /
			
 
	        Button cmdOptionF2 = (Button) findViewById(R.id.cmdOptionF2);
	        cmdOptionF2.setText("Home");
	        cmdOptionF2.setOnClickListener(new OnClickListener() {  

	        	public void onClick(View view) {  
       		        	
	         	BlackBoard bb  = (BlackBoard)getApplicationContext();
	         	bb.setHomeNLC(bb.getOrigin().strNLC); 
	         	
	        	Toast.makeText(TimeTableCriteria.this, "F2 Home Clicked", Toast.LENGTH_SHORT).show();  

	        	}
	        }); 

*/	        
		    doCheckComplete();
	   }

		@Override
		protected void onActivityResult(int requestCode, int resultCode, Intent data) {
			// TODO error handling
		    if (requestCode == 1) {
		        if(resultCode == RESULT_OK){
		        	Location origin = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);
		            
		         	AppContext bb  = (AppContext)getApplicationContext();
		         	bb.setOrigin(origin);

					TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
					txtOrigin.setText(origin.getDescription());
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 2) {
		        if(resultCode == RESULT_OK){
		        	Location destination = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);

		         	AppContext bb  = (AppContext)getApplicationContext();
		         	bb.setDestination(destination);
		            
		         	TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
		         	txtDestination.setText(destination.getDescription() );
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 3) {
		        if(resultCode == RESULT_OK){
		        	// TODO Journey selected?
		        	
					Intent returnIntent = new Intent();
					returnIntent.putExtra("result",-1);
					setResult(RESULT_OK,returnIntent);
					finish();           	               	 


		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    doCheckComplete();		    

		}

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}


	void doCheckComplete(){
	        Button cmdSearch = (Button) findViewById(R.id.cmdSearch);
			TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
			String strOrigin = txtOrigin.getText().toString();
			TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
			String strDestination = txtDestination.getText().toString();

	    	if((strOrigin.length() > 0) && (strDestination.length() > 0)){
	    		cmdSearch.setEnabled(true);
	    		cmdSearch.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
	    	} else {
	    		cmdSearch.setEnabled(false);
	    		cmdSearch.setBackgroundColor(JMgetColor(R.color.button_background_disabled, getTheme()));
	  		
	    	}
	    	
	    	AppContext bb  = (AppContext)getApplicationContext();
	        TextView txtDepartArrive = (TextView) findViewById(R.id.capTime);
			if(bb.getSearchDirection()==0){
				txtDepartArrive.setText("Depart");
			} else {
				txtDepartArrive.setText("Arrive");
			}
			
			TextView txtTime = (TextView) findViewById(R.id.txtTimeTT);
			txtTime.setText(DataConvert.displayTextTime(bb.getSearchDate()));

	    }
		

}

