package com.example.twolibs.TimeTableGUI;


import java.util.ArrayList;
import java.util.List;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R.color;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;
import com.example.twolibs.R.menu;
import com.example.twolibs.TimeTableBL.SearchResponse;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTSearch;
import com.example.twolibs.TimeTableBL.TTSearchCriteria;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.os.Bundle;
import android.widget.Button;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;




public class TwoLibs extends ListActivity
{
	private static final int VISIBLE = 0;
	private static final int INVISIBLE = 4;
	
	// Support for menu switching
	int iCurrentMenu = -1;
	int iCurrentSelection = -1;
	
    Context context = null;
	
	List<TTJourney> list = new ArrayList<TTJourney>();
	JourneyListAdaptor adapter;
	
	
	ListView listview;

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}

	/** Called when the activity is first created. */
	
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_timetableresults);
        context = this;

        // here, we dynamically load the library at runtime
        // before calling the native method.
        //
		
		setTitle(" Journeys");
        
 //       System.loadLibrary("twolib-second");
        
//        doLoad();

  
        listview = (ListView) findViewById(android.R.id.list);
     	final AppContext bb  = (AppContext)getApplicationContext();
     	

        adapter = new JourneyListAdaptor(this,list,bb);
        setListAdapter(adapter);
        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
            	
            	

                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	parent.getChildAt(j).setBackgroundColor(Color.TRANSPARENT);
                }

                if (position == iCurrentSelection){
                    setMenu(0);
                    
                    // Null the selected journey
                    bb.selJourney =  null;
                    iCurrentSelection = -1;

            	} else {
            		
                    setMenu(1);
 
                    // Record the selected journey
                    bb.selJourney =  list.get(position);
                    iCurrentSelection = position;

	                // change the background color of the selected element
	                view.setBackgroundColor(JMgetColor(R.color.selection_background, getTheme()));
           		
                }
            }
          });
        
        doSearch();

        setMenu(0);
   
        
        
   }
           
 

    
	public void doSearch(){
    	        
    	TextView tv = (TextView) findViewById(R.id.textView2);
 
     	AppContext bb  = (AppContext)getApplicationContext();
     	Location objOrigin = bb.getOrigin();
     	
     	if(objOrigin.getCRS().equals("")){
     		tv.setText("No origin specified"); 
     		return;
     	}
     	Location objDestination = bb.getDestination();
    	if(objDestination.getCRS().equals("")){
     		tv.setText("No destination specified"); 
     		return;
     	}
    	
    	TTSearchCriteria TTCrit = bb.ttSearch.setupDefaults(objOrigin, objDestination, bb.getSearchDate(), bb.getSearchDirection(), bb.getChanges());

    	SearchResponse resp = bb.ttSearch.doSearch(TTCrit);
         
        tv.setText(resp.extra); 
       
        list = resp.objTTsearchResults.getSr_journeys();
        adapter.clear();
        adapter.addAll(list);
        adapter.notifyDataSetChanged();
        
    	
    }
	
	
    private void setMenu(int iMenu){
    	if (iMenu == iCurrentMenu){
    		// No change required
    	} else {
    		// Delete the current
            LinearLayout layFormMenu = (LinearLayout)findViewById(R.id.layFormMenu);  
            layFormMenu.removeAllViews();               
             // Create new LayoutInflater - this has to be done this way, as you can't directly inflate an XML without creating an inflater object first             

             LayoutInflater inflater = getLayoutInflater();   
             if (iMenu == 0) {
                 layFormMenu.addView(inflater.inflate(R.layout.timetableresults_menu0, null));
 
                 // setup callbacks
                 Button cmdEarlier = (Button) findViewById(R.id.cmdEarlier);
                 cmdEarlier.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 	Toast.makeText(TwoLibs.this, "Earlier  Clicked", Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                 

                 Button cmdLater = (Button) findViewById(R.id.cmdLater);
                 cmdLater.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 	Toast.makeText(TwoLibs.this, "Later  Clicked", Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                 
                 Button cmdDone = (Button) findViewById(R.id.cmdDone);
                 cmdDone.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  


					Intent returnIntent = new Intent();
					returnIntent.putExtra("result",-1);
					setResult(RESULT_OK,returnIntent);
					finish();           	               	 
             	}
                 });
                 
             } else {
                 layFormMenu.addView(inflater.inflate(R.layout.timetableresults_menu1, null));

                 // setup callbacks
                   

                 Button cmdLater = (Button) findViewById(R.id.cmdFares);
                 cmdLater.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

                 	Toast.makeText(TwoLibs.this, "Fares  Clicked", Toast.LENGTH_SHORT).show();  
          
                 	} 
                 });
                 
                 Button cmdDone = (Button) findViewById(R.id.cmdDone);
                 cmdDone.setOnClickListener(new OnClickListener() {  

                 	public void onClick(View view) {  

    					Intent returnIntent = new Intent();
    					returnIntent.putExtra("result",-1);
    					setResult(RESULT_OK,returnIntent);
    					finish();           	               	 
                 	 
                 	}
                 });
                 
           }  		
    		
    		// Setup the new
    		iCurrentMenu = iMenu;
    	}
    	
    }
  
    public boolean onCreateOptionsMenu(Menu menu) {
    	// Inflate the menu items for use in the action bar
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu_logon, menu);
    	return super.onCreateOptionsMenu(menu);
    	}
    

    @Override public boolean onOptionsItemSelected(MenuItem item) {
    	// Handle item selection     
    	if (item.getItemId() == R.id.cmdSync) {
			Toast.makeText(TwoLibs.this, "sync data", Toast.LENGTH_SHORT).show();
			return true;
		}
		if (item.getItemId() == R.id.cmdHelp) {
			Toast.makeText(TwoLibs.this, "help dialogue", Toast.LENGTH_SHORT).show();
			return true;
		}
    	return super.onOptionsItemSelected(item);
    }
 
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

	    if (requestCode == 1) {
	    	setMenu(0);
	        if(resultCode == RESULT_OK){
	        	// Leg selected?
	        }
	        if (resultCode == RESULT_CANCELED) {
	            //Write your code if there's no result
	        }
	    }

	}


}

