/*
 * Copyright (c) 2018 PlanGrid, Inc. All rights reserved.
 */

package com.example.descudero.workmanagerbugsample.workmanager

import android.annotation.SuppressLint
import android.arch.lifecycle.LiveData
import androidx.work.Constraints
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequest
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.Operation
import androidx.work.WorkContinuation
import androidx.work.WorkInfo
import androidx.work.WorkManager
import androidx.work.Worker

class ProjectSyncManager(private val projectUid: String) {
    companion object {
        private const val projectSyncWorkerTag = "projectSyncWorkerTag"
        private fun requiredWorkerTag(projectUid: String) = "required-worker-$projectUid"
        private fun uniqueWorkName(projectUid: String) = "unique-work-$projectUid"
        private fun finalWorker(projectUid: String) = "final-worker-$projectUid"

        fun cancelAllDownloads(): LiveData<Operation.State> {
            return WorkManager.getInstance().cancelAllWorkByTag(projectSyncWorkerTag).state
        }
    }

    // TODO add project uid as a separate tag
    // TODO backoff policy for workers?
    // TODO should this be replace or append or keep? or protect against calling sync multiple times? should they stack (append)?
    private val constraints = Constraints.Builder()
        .setRequiredNetworkType(NetworkType.CONNECTED)
        .build()

    fun sync() {
//        WorkManager.getInstance().beginWith(
//            listOf(
//                OneTimeWorkRequestBuilder<DownloadCommentsWorker>().build(),
//                OneTimeWorkRequestBuilder<DownloadCommentsWorker>().build(),
//                OneTimeWorkRequestBuilder<DownloadCommentsWorker>().build(),
//                OneTimeWorkRequestBuilder<DownloadCommentsWorker>().build()
//            )
//        ).then(
//            OneTimeWorkRequestBuilder<FinalWorker>().addTag("finally").build()
//        ).enqueue()

//        WorkManager.getInstance().beginUniqueWork("unique", ExistingWorkPolicy.KEEP, OneTimeWorkRequestBuilder<DownloadCommentsWorker>()
//            .build()).then(OneTimeWorkRequestBuilder<FinalWorker>().addTag("finally").build()).enqueue()

        WorkContinuation
            .combine(createWorkContinuations())
            .then(OneTimeWorkRequestBuilder<FinalWorker>().build())
            .enqueue()
    }

    fun requiredSyncStatus(): LiveData<List<WorkInfo>> {
        return WorkManager.getInstance().getWorkInfosByTagLiveData(requiredWorkerTag(projectUid))
    }

    fun syncStatus(): LiveData<List<WorkInfo>> {
        return WorkManager.getInstance().getWorkInfosForUniqueWorkLiveData(uniqueWorkName(projectUid))
    }

    fun cancelSync(): LiveData<Operation.State> {
        return WorkManager.getInstance().cancelUniqueWork(uniqueWorkName(projectUid)).state
    }

    @SuppressLint("EnqueueWork")
    private fun createWorkContinuations(): List<WorkContinuation> {
        val downloadAnnotationDigestWorker = createWorker<DownloadAnnotationDigestWorker>()
        val downloadAssetsWorker = createWorker<DownloadAssetsWorker>()
        val downloadCommentsWorker = createWorker<DownloadCommentsWorker>()
        val downloadDocumentsWorker = createWorker<DownloadDocumentsWorker>()
        val downloadEventsWorker = createWorker<DownloadEventsWorker>()
        val downloadFieldReportsWorker = createWorker<DownloadFieldReportsWorker>()
        val downloadHistorySetWorker = createWorker<DownloadHistorySetWorker>()
        val downloadIssueListsWorker = createWorker<DownloadIssueListsWorker>()
        val downloadProjectDigestWorker = createWorker<DownloadProjectDigestWorker>()
        val downloadRfiWorker = createWorker<DownloadRfisWorker>()
        val downloadSheetsWorker = createWorker<DownloadSheetsWorker>()
        val downloadSheetTextWorker = createWorker<DownloadSheetTextWorker>()
        val downloadSheetVersionsWorker = createWorker<DownloadSheetVersionsWorker>()
        val downloadSnapshotsWorker = createWorker<DownloadSnapshotsWorker>()
        val downloadStampMetaWorker = createWorker<DownloadStampMetaWorker>()
        val downloadTasksWorker = createWorker<DownloadTasksWorker>()
        val downloadUserEventsWorker = createWorker<DownloadUserEventsWorker>()
        val downloadUserGroupsWorker = createWorker<DownloadUserGroupsWorker>()
        val downloadUsersWorker = createWorker<DownloadUsersWorker>()

        val path1 = WorkManager.getInstance()
            .beginWith(listOf(downloadHistorySetWorker, downloadSheetVersionsWorker))
            .then(downloadSheetsWorker)

        val path2 = WorkManager.getInstance()
            .beginWith(
                listOf(
                    downloadSheetsWorker,
                    downloadSheetVersionsWorker,
                    downloadCommentsWorker,
                    downloadTasksWorker,
                    downloadProjectDigestWorker,
                    downloadAnnotationDigestWorker
                )
            )
            .then(downloadUserEventsWorker)

        val path3 = WorkManager.getInstance()
            .beginWith(
                listOf(
                    downloadRfiWorker,
                    downloadProjectDigestWorker,
                    downloadAnnotationDigestWorker,
                    downloadFieldReportsWorker,
                    downloadSnapshotsWorker,
                    downloadTasksWorker
                )
            )
            .then(downloadAssetsWorker)

        val path4 = WorkManager.getInstance()
            .beginWith(
                listOf(
                    downloadProjectDigestWorker
                )
            )
            .then(downloadRfiWorker)

        val path5 = WorkManager.getInstance()
            .beginWith(
                listOf(
                    downloadAnnotationDigestWorker
                )
            )
            .then(downloadFieldReportsWorker)

        val extra = WorkManager.getInstance()
            .beginWith(
                listOf(
                     downloadAnnotationDigestWorker,
                     downloadAssetsWorker,
                     downloadCommentsWorker,
                     downloadDocumentsWorker,
                     downloadEventsWorker,
                     downloadFieldReportsWorker,
                     downloadHistorySetWorker,
                     downloadIssueListsWorker,
                     downloadProjectDigestWorker,
                     downloadRfiWorker,
                     downloadSheetsWorker,
                     downloadSheetTextWorker,
                     downloadSheetVersionsWorker,
                     downloadSnapshotsWorker,
                     downloadStampMetaWorker,
                     downloadTasksWorker,
                     downloadUserEventsWorker,
                     downloadUserGroupsWorker,
                     downloadUsersWorker
                )
            )

        return listOf(path1, path2, path3, path4, path5, extra)
    }

    private inline fun <reified T : Worker> createWorker(vararg tags: String): OneTimeWorkRequest {
        val builder = OneTimeWorkRequestBuilder<T>()
        tags.forEach { tag -> builder.addTag(tag) }
//        builder.setConstraints(constraints)
        return builder.build()
    }
}