/*
 * Copyright (c) 2018 PlanGrid, Inc. All rights reserved.
 */

package com.example.descudero.workmanagerbugsample.workmanager

import android.content.Context
import androidx.work.Result
import androidx.work.Worker
import androidx.work.WorkerParameters
import kotlin.random.Random

abstract class RootWorker(context: Context, workerParameters: WorkerParameters) : Worker(context, workerParameters) {
    override fun doWork(): Result {
        System.out.println("$this::class.java - Started")
        Thread.sleep(Random.nextLong(3000))
        System.out.println("$this::class.java - Done")
        return Result.success()
    }
}