package com.robotsandpencils.biotest.domain.error

/**
 * Enumeration of Error Codes for exceptions thrown in the domain layer.
 *
 * Since the `domain` module is a pure Java library, we can't use the Android
 * localization features, throwing a [DomainException] with one of these error
 * codes allows the presentation layer to lookup an appropriate localized error message
 *
 * Resolving of error messages is done by [com.varomoney.varo.DomainErrorResolver]
 */
enum class DomainError {

    EMAIL_INVALID,

    PASSWORD_TOO_SHORT,
    PASSWORD_TOO_LONG,
    PASSWORD_NO_DIGITS,
    PASSWORD_NO_UPPERCASE,
    PASSWORD_MUST_MATCH,

    ADDRESS_INVALID_STREET,
    ADDRESS_INVALID_CITY,
    ADDRESS_INVALID_STATE,
    ADDRESS_INVALID_ZIP,
    ADDRESS_MISSING_SECONDARY,
    ADDRESS_INCORRECT_SECONDARY,
    ADDRESS_NOT_DELIVERABLE,
    ADDRESS_NOT_FOUND,

    SECURITY_QUESTION_INVALID,

    OCCUPATION_INVALID,
    INCOME_SOURCE_INVALID,
    TRANSFER_COUNT_INVALID,
    WITHDRAWAL_COUNT_INVALID,

    VERIFICATION_CODE_INVALID_LENGTH,
    VERIFICATION_CODE_ONLY_DIGITS,

    NAME_TOO_SHORT,
    NAME_TOO_LONG,
    NAME_INVALID_CHARACTERS,
    NAME_TOO_MANY_SPACES,

    PHONE_NUMBER_TOO_SHORT,
    PHONE_NUMBER_TOO_LONG,
    PHONE_NUMBER_INVALID_CHARACTERS,

    SOCIAL_SECURITY_NUMBER_TOO_SHORT,
    SOCIAL_SECURITY_NUMBER_TOO_LONG,
    SOCIAL_SECURITY_NUMBER_INVALID_CHARACTERS,
    SOCIAL_SECURITY_NUMBERS_MUST_MATCH,
    SOCIAL_SECURITY_NUMBER_INVALID,

    // smarty streets
    FOOTNOTE_ZIP4_NOT_MATCHED_INVALID_ADDRESS,
    FOOTNOTE_SECONDARY_INFORMATION_INCORRECT,
    FOOTNOTE_PRIMARY_NUMBER_MISSING,
    FOOTNOTE_PRIMARY_NUMBER_INVALID,
    FOOTNOTE_REQUIRES_SECONDARY_NUMBER,
    FOOTNOTE_PO_RR_HC_MISSING,
    FOOTNOTE_PO_RR_HC_INVALID,
    FOOTNOTE_VALID_ADDRESS_NO_POSTAL_SERVICE,

    REGISTRATION_FAILED,

    BIOMETRICS_AUTHENTICATION_FAILURE,
    BIOMETRICS_CANCELLED_BY_USER,
    BIOMETRICS_LOCKOUT,
    BIOMETRICS_LOCKOUT_PERMANENT,

    SENDER_INSUFFICIENT_BALANCE,

    // Account Transfer Errors
    TRANSFER_INSUFFICIENT_FUNDS,
    TRANSFER_INVALID_AMOUNT,
    TRANSFER_INVALID_DESTINATION,
    TRANSFER_INVALID_SOURCE,
    TRANSFER_TRANSACTION_LIMIT_ERROR,
    TRANSFER_INVALID_SOURCE_DESTINATION_COMBINATION,
    TRANSFER_INVALID_BANKING_LIMITS,

    // Savings account application
    SAVINGS_ACCOUNT_MISSING_SSN,

    // Generic error when the user hasn't granted app permissions
    PERMISSION_NOT_GRANTED,

    // CDV Deposits Verification
    CLIENT_LIMIT_REACHED,
    TOO_MANY_ATTEMPTS,
    CHALLENGE_FAILED,

    // Account and Routing numbers
    ROUTING_NUMBER_INVALID,
    ACCOUNT_NUMBER_INVALID,

    ACCOUNT_NUMBERS_MUST_MATCH,
    INVALID_FUNDING_ACCOUNT,

    INVALID_ACH_ACCOUNT,

    // General error
    ERROR;


    companion object {
        var errorResolver: DomainErrorResolver? = null

        interface DomainErrorResolver {
            fun localizedMessage(error: DomainError): String
        }
    }
}
