package com.robotsandpencils.biotest.domain.error

import com.robotsandpencils.biotest.domain.error.DomainError

open class DomainException(val domainError: DomainError, message: String? = null, cause: Throwable? = null) :
        Throwable(message, cause) {

    override fun getLocalizedMessage(): String {
        return DomainError.errorResolver?.localizedMessage(domainError) ?: "No localized error message for ${domainError.name}"
    }
}
