package com.robotsandpencils.biotest.domain.repository

import io.reactivex.Observable

interface AuthTokenRepository {

    /**
     * Refresh token. Observe changes using the refreshTokenUpdated observable.
     */
    var refreshToken: String

    /**
     * Access token. Only kept in memory.
     */
    var accessToken: String

    /**
     * Used for basic auth fallback (for auth apis)
     */
    val userId: String

    /**
     * Used for basic auth fallback (for auth apis)
     */
    val password: String

    /**
     * Used to fire a refresh token update to any watchers.
     */
    fun fireRefreshTokenUpdate(refreshToken: String)

    /**
     * Used to observe refresh token updates.
     */
    fun refreshTokenUpdated(): Observable<String>

    /**
     * Is there a valid auth token?
     */
    fun hasAuthToken(): Boolean
}
