package com.robotsandpencils.biotest.domain.repository

import io.reactivex.Completable
import io.reactivex.Observable
import io.reactivex.Single
import java.util.*

interface SessionRepository {
    fun logIn(refreshToken: String): Single<AuthResponse>
    fun logOut(revokeAndRemoveTokens: Boolean): Completable

    /**
     * Observable that will emit a CurrentUser upon login, and complete upon logout
     */
    fun currentUser(): Observable<CurrentUser>

    /**
     * True if the user is authenticated.
     */
    val isLoggedIn: Boolean

    /**
     * Observable that fires true if the background session limit expired when the app was resumed.
     * This is a signal for any activities to immediately exit and fire up the launcher activity.
     */
    fun backgroundSessionTimeout(): Observable<Boolean>

    /**
     * Fire the background session timeout
     */
    fun fireBackgroundSessionTimeout()
}

data class AuthResponse(
    val access_token: String,
    val token_type: String,
    val refresh_token: String,
    val expires_in: String,
    val scope: String,
    val jti: String,
    val varo_client_id: UUID
)

data class CurrentUser(
    val clientId: UUID
) {
    override fun toString() =
        "{clientId = $clientId}"
}

