package com.robotsandpencils.biotest.domain.usecase

import com.robotsandpencils.biotest.domain.usecase.transformer.Noop
import com.robotsandpencils.biotest.domain.usecase.transformer.TransformerProvider
import io.reactivex.Completable


/**
 * Base class for use cases that returns a Completable.
 *
 * This class is supposed to be used when there is no data to return, such as when downloading
 * information and updating the local cache. Or for single shot actions, like login/logout.
 */
abstract class CompletableUseCase<Input> {
    protected abstract fun createCompletable(data: Input): Completable

    fun execute(withData: Input, transformer: TransformerProvider = Noop): Completable {
        return createCompletable(withData).compose(transformer.provideCompletableTransformer())
    }
}

fun CompletableUseCase<Unit>.execute(transformer: TransformerProvider = Noop) =
        this.execute(withData = Unit, transformer = transformer)
