package com.robotsandpencils.biotest.domain.usecase

import com.robotsandpencils.biotest.domain.usecase.transformer.Noop
import com.robotsandpencils.biotest.domain.usecase.transformer.TransformerProvider
import io.reactivex.Single

/**
 * Base class to be used when we only want a Single response.
 *
 * This is intended to be used when we want to read data that we know is
 * already available in the cache.
 */
abstract class SingleUseCase<Input, Output> {
    protected abstract fun createSingle(data: Input): Single<Output>

    fun execute(withData: Input, transformer: TransformerProvider = Noop): Single<Output> {
        return createSingle(withData).compose(transformer.provideSingleTransformer())
    }
}

fun <Output> SingleUseCase<Unit, Output>.execute(transformer: TransformerProvider = Noop) =
        this.execute(withData = Unit, transformer = transformer)
