package com.robotsandpencils.biotest.system.usecase.biometrics

import com.robotsandpencils.biotest.domain.usecase.SingleUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Single

/**
 * Returns true if credentials are stored in the shared preferences.
 */
class AreBionmetricsCredentialsStoredUseCase(
    private val biometricsRepository: BiometricsRepository
) : SingleUseCase<Unit, Boolean>() {

    override fun createSingle(data: Unit): Single<Boolean> =
        biometricsRepository.areCredentialsStored()
}
