package com.robotsandpencils.biotest.system.usecase.biometrics

import android.annotation.SuppressLint
import android.app.Activity
import com.robotsandpencils.biotest.domain.usecase.CompletableUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Completable

/**
 * Performs a Biometrics login using either the system dialog or a compat dialog. Takes
 * the encrypted credentials, and decrypts them after a successful biometric login and
 * returns the VaroLogin object containing the decrypted credentials. Should only be called
 * on devices with biometric hardware, otherwise guaranteed to crash.
 */
class BiometricsLoginUseCase constructor(private val biometricsRepository: BiometricsRepository) : CompletableUseCase<Activity>() {
    @SuppressLint("NewApi")
    override fun createCompletable(data: Activity): Completable =
        biometricsRepository.login(data)
}
