package com.robotsandpencils.biotest.system.usecase.biometrics

import android.annotation.SuppressLint
import com.robotsandpencils.biotest.domain.usecase.CompletableUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Completable

/**
 * Clears the shared preferences of any biometrics related data.
 */
class ClearBiometricsCredentialsUseCase(private val biometricsRepository: BiometricsRepository) : CompletableUseCase<Unit>() {

    @SuppressLint("NewApi")
    override fun createCompletable(data: Unit): Completable =
        biometricsRepository.clear()

}
