package com.robotsandpencils.biotest.system.usecase.biometrics

import com.robotsandpencils.biotest.domain.usecase.CompletableUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Completable

/**
 * Clear biometrics enrollment if the user logging in is different from the user who enrolled.
 * Pass in the username of the user (email address).
 */
class ClearBiometricsOnUserMismatchUseCase(val biometricsRepository: BiometricsRepository)
    : CompletableUseCase<String>() {

    override fun createCompletable(data: String): Completable =
        biometricsRepository.clearIfUserMismatch(data)

}
