package com.robotsandpencils.biotest.system.usecase.biometrics

import android.annotation.SuppressLint
import android.app.Activity
import com.robotsandpencils.biotest.domain.repository.AuthTokenRepository
import com.robotsandpencils.biotest.domain.usecase.CompletableUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Completable

/**
 * Perform a biometrics enrollment. This shows the system, or a compat dialog, for fingerprint
 * input, and then encrypts the refresh token into shared preferences. Should only be called
 * on devices with biometric hardware, otherwise guaranteed to crash.
 *
 * Requires an activity for context, and the username (email address) of the user.
 */
class EnrollBiometricsUseCase(
    private val biometricsRepository: BiometricsRepository,
    private val authTokenRepository: AuthTokenRepository
) : CompletableUseCase<EnrollBiometricsUseCase.EnrollRequest>() {

    data class EnrollRequest(val activity: Activity, val username: String)

    @SuppressLint("NewApi")
    override fun createCompletable(data: EnrollRequest): Completable =
        biometricsRepository.enroll(data.activity, data.username, authTokenRepository.refreshToken)
}
