package com.robotsandpencils.biotest.system.usecase.biometrics

import android.app.Activity
import com.robotsandpencils.biotest.domain.usecase.SingleUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Single

/**
 * Returns true if the device has biometric hardware.
 */
class HasBiometricHardwareUseCase(
    private val biometricsRepository: BiometricsRepository
) : SingleUseCase<Activity, Boolean>() {

    override fun createSingle(data: Activity): Single<Boolean> =
        biometricsRepository.hasBiometricHardware(data)
}
