package com.varomoney.varo.system.usecase.biometrics

import android.app.Activity
import com.robotsandpencils.biotest.domain.usecase.SingleUseCase
import com.robotsandpencils.biotest.system.repository.BiometricsRepository
import io.reactivex.Single

/**
 * Returns true if the user has added biometric patterns to the device. For example, on
 * a device with a fingerprint sensor, the user has enrolled at least one fingerprint. If
 * this returns false, but hasBiometricHardware returns true, then the user hasn't configured
 * their device for biometrics yet, so we likely shouldn't give them the option to use it.
 */
class HasEnrolledBiometricPatternsUseCase(
    private val biometricsRepository: BiometricsRepository
) : SingleUseCase<Activity, Boolean>() {
    override fun createSingle(data: Activity): Single<Boolean> =
        biometricsRepository.hasEnrolledBiometricPatterns(data)
}
