package com.rogererill.motionlayoutlistbug

import android.os.Bundle
import android.support.constraint.motion.MotionLayout
import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.DividerItemDecoration
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.View

class MainActivity : AppCompatActivity() {

  private val motionLayout by lazy { findViewById<MotionLayout>(R.id.motion_layout) }
  private val movingView by lazy { findViewById<View>(R.id.moving_view) }
  private val resultList by lazy { findViewById<RecyclerView>(R.id.list) }

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    setContentView(R.layout.activity_main)

    resultList.layoutManager = LinearLayoutManager(this)
    resultList.addItemDecoration(DividerItemDecoration(this, DividerItemDecoration.VERTICAL))

    setListAdapter()

    // When clicking the view, send it to the top of the screen
    movingView.setOnClickListener {
      if (!isAtTransitionEnd()) {
        motionLayout.transitionToEnd()
      }
    }
  }

  override fun onBackPressed() {
    if (isAtTransitionEnd()) {
      motionLayout.transitionToStart()
    } else {
      super.onBackPressed()
    }
  }

  private fun isAtTransitionEnd() = motionLayout.progress == 1.0f

  private fun setListAdapter() {
    val items = (0..80).map { Result("Result $it") }
    resultList.adapter = ResultAdapter(items)
  }
}
