package com.rogererill.motionlayoutlistbug

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView

class ResultAdapter(var data: List<Result>) : RecyclerView.Adapter<ResultAdapter.ViewHolder>() {

  override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
    return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.result_row, parent, false))
  }

  override fun getItemCount() = data.size

  override fun onBindViewHolder(holder: ViewHolder, position: Int) {
    holder.bind(data[position])
  }

  class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
    private val title: TextView by lazy { view.findViewById<TextView>(R.id.title) }

    fun bind(item: Result) {
      title.text = item.title
    }
  }
}