# keep names of exception classes
-keepname class * extends java.lang.Throwable

# start android AIDL compiled class
-keep class android.content.** { *; }

# start Framework

-keepclassmembers public class * implements eu.inmite.android.fw.interfaces.IService {
   public <init>(...);
}
# end Framework

# Notifications
-keep class * implements com.avast.android.cleaner.notifications.notification.TrackedNotification

# start BUTTERKNIFE
-dontwarn butterknife.internal.ButterKnifeProcessor
-keep,allowobfuscation @interface butterknife.*
-keep class **$$ViewInjector {
    public static void inject(...);
    public static void reset(...);
}
-keep class **$$ViewBinder {
    public static void bind(...);
    public static void unbind(...);
}
-keepclasseswithmembernames class * {
    @butterknife.* <fields>;
}
-keepclasseswithmembernames class * {
    @butterknife.* <methods>;
}
-keepclasseswithmembers class * {
    @butterknife.On* <methods>;
}
# end BUTTERKNIFE

# start ORM lite
-keepattributes Signature
-keep class com.j256.**
-keepclassmembers class com.j256.** { *; }
-keep enum com.j256.**
-keepclassmembers enum com.j256.** { *; }
-keep interface com.j256.**
-keepclassmembers interface com.j256.** { *; }
-keepclassmembers @com.j256.ormlite.table.DatabaseTable class * { *; }

-keepclassmembers class **DateTime {
    <init>(long);
    long getMillis();
}
-keepclassmembers public class * extends com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper {
   public <init>(...);
}
-keep @com.j256.** class *
-keepclassmembers @com.j256.** class * {
  @com.j256.** *;
}
-keep class * extends com.j256.ormlite.dao.BaseDaoImpl {
  public <init>(...);
}
# end ORM lite

# start OTTO
-keepclassmembers class ** {
    @com.squareup.otto.Subscribe public *;
    @com.squareup.otto.Produce public *;
}
# end OTTO

# start Math3
-dontwarn org.apache.commons.math3.**
# end Math3

# start dropbox
-keep class com.dropbox.** {*;}
# end dropbox

# start SHEPHERD CONFIG
-keep class com.avast.shepherd.DefaultConfigCustomLayer { *; }
# end SHEPHERD CONFIG

# Jsoup
-keep public class org.jsoup.** {
public *;
}

# start HEYZAP
-keep public class com.heyzap.** { *; }
-dontwarn com.heyzap.**
# end HEYZAP

# Facebook
-keep class com.facebook.** { *; }
# end Facebook

# start AD mob
-keep public class com.google.android.gms.ads.** {
   public *;
}
-keep public class com.google.ads.** {
   public *;
}
# end AD mob

# solution of crash https://butr.avast.com/browse/ACL-1550 (needed for feed library 1.6)
-keepclasseswithmembers class **$ViewHolder { *; }

-dontwarn org.apache.http.**
-keep class org.apache.http.** { *; }

# Application classes that will be serialized/deserialized over Gson
-keep class com.google.gson.examples.android.model.** { *; }

#GreenDAO
-keepclassmembers class * extends de.greenrobot.dao.AbstractDao {
    public static java.lang.String TABLENAME;
}
-keep class **$Properties

#horizontalVariableListView
-keep class it.sephiroth.** {*;}

#eventbus
-keepclassmembers class ** {
    public void onEvent(**);
    public void onEventMainThread(**);
}

#joda-time
-dontwarn org.joda.convert.**

#opencv
-keep class org.opencv.** {*;}

-keepclassmembers class com.sefford.circularprogressdrawable.CircularProgressDrawable { *;}

# for GSON Serialization
-keepclassmembers class com.avast.android.cleaner.batteryoptimizer.settings.** { *; }
-keepclassmembers class com.avast.android.cleaner.batteryoptimizer.conditions.** { *; }
-keepclassmembers class com.avast.android.cleaner.batteryoptimizer.profiles.BatteryOptimizerProfile { *; }
-keepnames class com.avast.android.cleaner.batteryoptimizer.settings.** { *; }
-keepnames class com.avast.android.cleaner.batteryoptimizer.conditions.** { *; }
-keepnames class com.avast.android.cleaner.batteryoptimizer.profiles.BatteryOptimizerProfile { *; }

# Gson uses generic type information stored in a class file when working with fields. Proguard
# removes such information by default, so configure it to keep all of it.
-keepattributes Signature

# Parcelable Creator
-keep class * implements android.os.Parcelable {
  public static android.os.Parcelable$Creator *;
}

# Icepick library
-dontwarn icepick.**
-keep class icepick.** { *; }
-keep class **$$Icepick { *; }
-keepclasseswithmembernames class * {
    @icepick.* <fields>;
}
-keepnames class * { @icepick.State *;}

# This must be there to avoid crash https://butr.avast.com/browse/ACL-3817 (this class is used in avg toolkit)
-keep class org.apache.commons.codec.binary.Hex {
    public <fields>;
    public <methods>;
}

-keep public enum com.avast.android.cleaner.batteryoptimizer.profiles.BatteryOptimizerProfile$ProfileType {
    **[] $VALUES;
    public *;
}
-keepattributes InnerClasses

# appsflyer
-dontwarn com.android.installreferrer