package com.example.skeptick.room_simple_project

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import java.util.*

@Dao
interface UsersDao {

    @Query("SELECT * FROM users WHERE first_name = :firstName AND type = :type")
    suspend fun getByFirstNameAndTypeSuspend(firstName: String, type: UserEntity.Type): List<UserEntity>

    @Query("SELECT * FROM users WHERE first_name = :firstName AND type = :type")
    fun getByFirstNameAndType(firstName: String, type: UserEntity.Type): List<UserEntity>

    @Insert
    suspend fun insert(user: UserEntity)

    @Update
    suspend fun update(user: UserEntity)

}