/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LensCodeRewriter {
    private final AppInfoWithSubtyping appInfo;
    private final GraphLense graphLense;
    private final VerticalClassMerger.VerticallyMergedClasses verticallyMergedClasses;
    private final InternalOptions options;
    private final Map<DexProto, DexProto> protoFixupCache = new ConcurrentHashMap<DexProto, DexProto>();

    public LensCodeRewriter(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options) {
        this.appInfo = appView.appInfo();
        this.graphLense = appView.graphLense();
        this.verticallyMergedClasses = appView.verticallyMergedClasses();
        this.options = options;
    }

    private Value makeOutValue(Instruction insn, IRCode code, Set<Value> collector) {
        if (insn.outValue() == null) {
            return null;
        }
        Value newValue = code.createValue(insn.outValue().getTypeLattice(), insn.getLocalInfo());
        collector.add(newValue);
        return newValue;
    }

    public void rewrite(IRCode code, DexEncodedMethod method) {
        Set<Value> newSSAValues = Sets.newIdentityHashSet();
        ListIterator blocks = code.blocks.listIterator();
        boolean mayHaveUnreachableBlocks = false;
        while (blocks.hasNext()) {
            boolean anyGuardsRenamed;
            BasicBlock block = (BasicBlock)blocks.next();
            if (block.hasCatchHandlers() && this.options.enableVerticalClassMerging && (anyGuardsRenamed = block.renameGuardsInCatchHandlers(this.graphLense))) {
                mayHaveUnreachableBlocks |= this.unlinkDeadCatchHandlers(block);
            }
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction newNewArray;
                DexType newType;
                DexField actualField;
                DexField field;
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeCustom()) {
                    InvokeCustom invokeCustom = current.asInvokeCustom();
                    DexCallSite callSite = invokeCustom.getCallSite();
                    DexProto newMethodProto = this.appInfo.dexItemFactory.applyClassMappingToProto(callSite.methodProto, this.graphLense::lookupType, this.protoFixupCache);
                    DexMethodHandle newBootstrapMethod = this.rewriteDexMethodHandle(callSite.bootstrapMethod, method, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                    boolean isLambdaMetaFactory = this.appInfo.dexItemFactory.isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
                    UseRegistry.MethodHandleUse methodHandleUse = isLambdaMetaFactory ? UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
                    List<DexValue> newArgs = this.rewriteBootstrapArgs(callSite.bootstrapArgs, method, methodHandleUse);
                    if (newMethodProto.equals(callSite.methodProto) && newBootstrapMethod == callSite.bootstrapMethod && newArgs.equals(callSite.bootstrapArgs)) continue;
                    DexCallSite newCallSite = this.appInfo.dexItemFactory.createCallSite(callSite.methodName, newMethodProto, newBootstrapMethod, newArgs);
                    InvokeCustom newInvokeCustom = new InvokeCustom(newCallSite, invokeCustom.outValue(), invokeCustom.inValues());
                    iterator2.replaceCurrentInstruction(newInvokeCustom);
                    continue;
                }
                if (current.isConstMethodHandle()) {
                    DexMethodHandle handle = current.asConstMethodHandle().getValue();
                    DexMethodHandle newHandle = this.rewriteDexMethodHandle(handle, method, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                    if (newHandle == handle) continue;
                    ConstMethodHandle newInstruction = new ConstMethodHandle(this.makeOutValue(current, code, newSSAValues), newHandle);
                    iterator2.replaceCurrentInstruction(newInstruction);
                    continue;
                }
                if (current.isInvokeMethod()) {
                    List<Value> newInValues;
                    Value newOutValue;
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    DexType invokedHolder = invokedMethod.getHolder();
                    if (!invokedHolder.isClassType()) continue;
                    if (invoke.isInvokeDirect()) {
                        this.checkInvokeDirect(method.method, invoke.asInvokeDirect());
                    }
                    GraphLense.GraphLenseLookupResult lenseLookup = this.graphLense.lookupMethod(invokedMethod, method.method, invoke.getType());
                    DexMethod actualTarget = lenseLookup.getMethod();
                    Invoke.Type actualInvokeType = lenseLookup.getType();
                    if (actualInvokeType == Invoke.Type.VIRTUAL) {
                        actualTarget = this.rebindVirtualInvokeToMostSpecific(actualTarget, invoke.inValues().get(0), method.method.holder);
                    }
                    if (actualTarget == invokedMethod && invoke.getType() == actualInvokeType) continue;
                    GraphLense.RewrittenPrototypeDescription prototypeChanges = this.graphLense.lookupPrototypeChanges(actualTarget);
                    GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
                    ConstInstruction constantReturnMaterializingInstruction = null;
                    if (prototypeChanges.hasBeenChangedToReturnVoid() && invoke.outValue() != null) {
                        constantReturnMaterializingInstruction = prototypeChanges.getConstantReturn(code, invoke.getPosition());
                        invoke.outValue().replaceUsers(constantReturnMaterializingInstruction.outValue());
                    }
                    Value value = newOutValue = prototypeChanges.hasBeenChangedToReturnVoid() ? null : this.makeOutValue(invoke, code, newSSAValues);
                    if (removedArgumentsInfo.hasRemovedArguments()) {
                        Log.info(this.getClass(), "Invoked method " + invokedMethod.toSourceString() + " with " + removedArgumentsInfo.numberOfRemovedArguments() + " arguments removed", new Object[0]);
                        newInValues = new ArrayList<Value>(actualTarget.proto.parameters.size());
                        for (int i = 0; i < invoke.inValues().size(); ++i) {
                            if (removedArgumentsInfo.isArgumentRemoved(i)) continue;
                            newInValues.add(invoke.inValues().get(i));
                        }
                        assert (newInValues.size() == actualTarget.proto.parameters.size() + (actualInvokeType == Invoke.Type.STATIC ? 0 : 1));
                    } else {
                        newInValues = invoke.inValues();
                    }
                    Invoke newInvoke = Invoke.create(actualInvokeType, actualTarget, null, newOutValue, newInValues);
                    iterator2.replaceCurrentInstruction(newInvoke);
                    if (constantReturnMaterializingInstruction != null) {
                        iterator2.add(constantReturnMaterializingInstruction);
                    }
                    DexType actualReturnType = actualTarget.proto.returnType;
                    DexType expectedReturnType = this.graphLense.lookupType(invokedMethod.proto.returnType);
                    if (newInvoke.outValue() == null || actualReturnType == expectedReturnType) continue;
                    throw new Unreachable("Unexpected need to insert a cast. Possibly related to resolving b/79143143.\n" + invokedMethod + " type changed from " + expectedReturnType + " to " + actualReturnType);
                }
                if (current.isInstanceGet()) {
                    InstanceGet instanceGet = current.asInstanceGet();
                    field = instanceGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstanceGet newInstanceGet = new InstanceGet(this.makeOutValue(instanceGet, code, newSSAValues), instanceGet.object(), actualField);
                    iterator2.replaceCurrentInstruction(newInstanceGet);
                    continue;
                }
                if (current.isInstancePut()) {
                    InstancePut instancePut = current.asInstancePut();
                    field = instancePut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstancePut newInstancePut = new InstancePut(actualField, instancePut.object(), instancePut.value());
                    iterator2.replaceCurrentInstruction(newInstancePut);
                    continue;
                }
                if (current.isStaticGet()) {
                    StaticGet staticGet = current.asStaticGet();
                    field = staticGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticGet newStaticGet = new StaticGet(this.makeOutValue(staticGet, code, newSSAValues), actualField);
                    iterator2.replaceCurrentInstruction(newStaticGet);
                    continue;
                }
                if (current.isStaticPut()) {
                    StaticPut staticPut = current.asStaticPut();
                    field = staticPut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticPut newStaticPut = new StaticPut(staticPut.inValue(), actualField);
                    iterator2.replaceCurrentInstruction(newStaticPut);
                    continue;
                }
                if (current.isCheckCast()) {
                    CheckCast checkCast = current.asCheckCast();
                    newType = this.graphLense.lookupType(checkCast.getType());
                    if (newType == checkCast.getType()) continue;
                    CheckCast newCheckCast = new CheckCast(this.makeOutValue(checkCast, code, newSSAValues), checkCast.object(), newType);
                    iterator2.replaceCurrentInstruction(newCheckCast);
                    continue;
                }
                if (current.isConstClass()) {
                    ConstClass constClass = current.asConstClass();
                    newType = this.graphLense.lookupType(constClass.getValue());
                    if (newType == constClass.getValue()) continue;
                    ConstClass newConstClass = new ConstClass(this.makeOutValue(constClass, code, newSSAValues), newType);
                    iterator2.replaceCurrentInstruction(newConstClass);
                    continue;
                }
                if (current.isInstanceOf()) {
                    InstanceOf instanceOf = current.asInstanceOf();
                    newType = this.graphLense.lookupType(instanceOf.type());
                    if (newType == instanceOf.type()) continue;
                    InstanceOf newInstanceOf = new InstanceOf(this.makeOutValue(instanceOf, code, newSSAValues), instanceOf.value(), newType);
                    iterator2.replaceCurrentInstruction(newInstanceOf);
                    continue;
                }
                if (current.isInvokeMultiNewArray()) {
                    InvokeMultiNewArray multiNewArray = current.asInvokeMultiNewArray();
                    newType = this.graphLense.lookupType(multiNewArray.getArrayType());
                    if (newType == multiNewArray.getArrayType()) continue;
                    InvokeMultiNewArray newMultiNewArray = new InvokeMultiNewArray(newType, this.makeOutValue(multiNewArray, code, newSSAValues), multiNewArray.inValues());
                    iterator2.replaceCurrentInstruction(newMultiNewArray);
                    continue;
                }
                if (current.isInvokeNewArray()) {
                    InvokeNewArray newArray = current.asInvokeNewArray();
                    newType = this.graphLense.lookupType(newArray.getArrayType());
                    if (newType == newArray.getArrayType()) continue;
                    newNewArray = new InvokeNewArray(newType, this.makeOutValue(newArray, code, newSSAValues), newArray.inValues());
                    iterator2.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (current.isMoveException()) {
                    MoveException moveException = current.asMoveException();
                    DexType newExceptionType = this.graphLense.lookupType(moveException.getExceptionType());
                    if (newExceptionType == moveException.getExceptionType()) continue;
                    iterator2.replaceCurrentInstruction(new MoveException(this.makeOutValue(moveException, code, newSSAValues), newExceptionType, this.options));
                    continue;
                }
                if (current.isNewArrayEmpty()) {
                    NewArrayEmpty newArrayEmpty = current.asNewArrayEmpty();
                    newType = this.graphLense.lookupType(newArrayEmpty.type);
                    if (newType == newArrayEmpty.type) continue;
                    newNewArray = new NewArrayEmpty(this.makeOutValue(newArrayEmpty, code, newSSAValues), newArrayEmpty.size(), newType);
                    iterator2.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (!current.isNewInstance()) continue;
                NewInstance newInstance = current.asNewInstance();
                DexType newClazz = this.graphLense.lookupType(newInstance.clazz);
                if (newClazz == newInstance.clazz) continue;
                NewInstance newNewInstance = new NewInstance(newClazz, this.makeOutValue(newInstance, code, newSSAValues));
                iterator2.replaceCurrentInstruction(newNewInstance);
            }
        }
        if (mayHaveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
        if (!newSSAValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, method).widening(newSSAValues);
        }
        assert (code.isConsistentSSA());
    }

    private void checkInvokeDirect(DexMethod method, InvokeDirect invoke) {
        if (this.verticallyMergedClasses == null) {
            return;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.name != this.appInfo.dexItemFactory.constructorMethodName) {
            return;
        }
        if (invoke.arguments().isEmpty()) {
            return;
        }
        Value receiver = invoke.arguments().get(0);
        if (!receiver.isPhi() && receiver.definition.isNewInstance()) {
            NewInstance newInstance = receiver.definition.asNewInstance();
            if (newInstance.clazz != invokedMethod.holder && this.verticallyMergedClasses.hasBeenMergedIntoSubtype(invokedMethod.holder)) {
                throw this.options.reporter.fatalError(String.format("Unable to rewrite `invoke-direct %s.<init>(new %s, ...)` in method `%s` after type `%s` was merged into `%s`. Please add the following rule to your Proguard configuration file: `-keep,allowobfuscation class %s`.", invokedMethod.holder.toSourceString(), newInstance.clazz, method.toSourceString(), invokedMethod.holder, this.verticallyMergedClasses.getTargetFor(invokedMethod.holder), invokedMethod.holder.toSourceString()));
            }
        }
    }

    private boolean unlinkDeadCatchHandlers(BasicBlock block) {
        assert (block.hasCatchHandlers());
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        List<DexType> guards = catchHandlers.getGuards();
        List<BasicBlock> targets = catchHandlers.getAllTargets();
        HashSet<DexType> previouslySeenGuards = new HashSet<DexType>();
        ArrayList<BasicBlock> deadCatchHandlers = new ArrayList<BasicBlock>();
        for (int i = 0; i < guards.size(); ++i) {
            boolean guardSeenBefore;
            DexType guard = this.graphLense.lookupType(guards.get(i));
            boolean bl = guardSeenBefore = !previouslySeenGuards.add(guard);
            if (!guardSeenBefore) continue;
            deadCatchHandlers.add(targets.get(i));
        }
        for (BasicBlock deadCatchHandler : deadCatchHandlers) {
            deadCatchHandler.unlinkCatchHandler();
        }
        assert (block.consistentCatchHandlers());
        return !deadCatchHandlers.isEmpty();
    }

    private List<DexValue> rewriteBootstrapArgs(List<DexValue> bootstrapArgs, DexEncodedMethod method, UseRegistry.MethodHandleUse use) {
        List<DexValue> newBootstrapArgs = null;
        boolean changed = false;
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            DexType oldType;
            DexType newType;
            DexValue argument = bootstrapArgs.get(i);
            DexValue.NestedDexValue newArgument = null;
            if (argument instanceof DexValue.DexValueMethodHandle) {
                newArgument = this.rewriteDexValueMethodHandle(argument.asDexValueMethodHandle(), method, use);
            } else if (argument instanceof DexValue.DexValueMethodType) {
                newArgument = this.rewriteDexMethodType(argument.asDexValueMethodType());
            } else if (argument instanceof DexValue.DexValueType && (newType = this.graphLense.lookupType(oldType = (DexType)((DexValue.DexValueType)argument).value)) != oldType) {
                newArgument = new DexValue.DexValueType(newType);
            }
            if (newArgument != null) {
                if (newBootstrapArgs == null) {
                    newBootstrapArgs = new ArrayList<DexValue>(bootstrapArgs.subList(0, i));
                }
                newBootstrapArgs.add(newArgument);
                changed = true;
                continue;
            }
            if (newBootstrapArgs == null) continue;
            newBootstrapArgs.add(argument);
        }
        return changed ? newBootstrapArgs : bootstrapArgs;
    }

    private DexValue.DexValueMethodHandle rewriteDexValueMethodHandle(DexValue.DexValueMethodHandle methodHandle, DexEncodedMethod context, UseRegistry.MethodHandleUse use) {
        DexMethodHandle oldHandle = (DexMethodHandle)methodHandle.value;
        DexMethodHandle newHandle = this.rewriteDexMethodHandle(oldHandle, context, use);
        return newHandle != oldHandle ? new DexValue.DexValueMethodHandle(newHandle) : methodHandle;
    }

    private DexMethodHandle rewriteDexMethodHandle(DexMethodHandle methodHandle, DexEncodedMethod context, UseRegistry.MethodHandleUse use) {
        if (methodHandle.isMethodHandle()) {
            DexMethodHandle.MethodHandleType newType;
            DexMethod actualTarget;
            DexMethod invokedMethod = methodHandle.asMethod();
            DexMethodHandle.MethodHandleType oldType = methodHandle.type;
            GraphLense.GraphLenseLookupResult lenseLookup = this.graphLense.lookupMethod(invokedMethod, context.method, oldType.toInvokeType());
            DexMethod rewrittenTarget = lenseLookup.getMethod();
            if (use == UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY) {
                actualTarget = rewrittenTarget;
                newType = lenseLookup.getType().toMethodHandle(actualTarget);
            } else {
                assert (use == UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                actualTarget = this.appInfo.dexItemFactory.createMethod(invokedMethod.holder, rewrittenTarget.proto, rewrittenTarget.name);
                newType = oldType;
                if (oldType.isInvokeDirect()) {
                    assert (rewrittenTarget.holder == actualTarget.holder);
                    newType = lenseLookup.getType().toMethodHandle(actualTarget);
                    assert (newType == DexMethodHandle.MethodHandleType.INVOKE_DIRECT || newType == DexMethodHandle.MethodHandleType.INVOKE_INSTANCE);
                }
            }
            if (newType != oldType || actualTarget != invokedMethod || rewrittenTarget != actualTarget) {
                return new DexMethodHandle(newType, actualTarget, rewrittenTarget != actualTarget ? rewrittenTarget : null);
            }
        } else {
            DexField field = methodHandle.asField();
            DexField actualField = this.graphLense.lookupField(field);
            if (actualField != field) {
                return new DexMethodHandle(methodHandle.type, actualField);
            }
        }
        return methodHandle;
    }

    private DexValue.DexValueMethodType rewriteDexMethodType(DexValue.DexValueMethodType type) {
        DexProto oldProto = (DexProto)type.value;
        DexProto newProto = this.appInfo.dexItemFactory.applyClassMappingToProto(oldProto, this.graphLense::lookupType, this.protoFixupCache);
        return newProto != oldProto ? new DexValue.DexValueMethodType(newProto) : type;
    }

    private DexMethod rebindVirtualInvokeToMostSpecific(DexMethod target, Value receiver, DexType context) {
        if (!receiver.getTypeLattice().isClassType()) {
            return target;
        }
        DexEncodedMethod encodedTarget = this.appInfo.definitionFor(target);
        if (encodedTarget == null || !this.canInvokeTargetWithInvokeVirtual(encodedTarget) || !this.hasAccessToInvokeTargetFromContext(encodedTarget, context)) {
            return target;
        }
        DexType receiverType = this.graphLense.lookupType(receiver.getTypeLattice().asClassTypeLatticeElement().getClassType());
        if (receiverType == target.holder) {
            return target;
        }
        DexEncodedMethod newTarget = this.appInfo.lookupVirtualTarget(receiverType, target);
        if (newTarget == null || newTarget.method == target) {
            return target;
        }
        if (!this.canInvokeTargetWithInvokeVirtual(newTarget) || !this.hasAccessToInvokeTargetFromContext(newTarget, context)) {
            return target;
        }
        return newTarget.method;
    }

    private boolean canInvokeTargetWithInvokeVirtual(DexEncodedMethod target) {
        return target.isVirtualMethod() && !target.method.holder.isInterface();
    }

    private boolean hasAccessToInvokeTargetFromContext(DexEncodedMethod target, DexType context) {
        assert (!target.accessFlags.isPrivate());
        DexType holder = target.method.holder;
        if (holder == context) {
            return true;
        }
        DexClass clazz = this.appInfo.definitionFor(holder);
        if (clazz == null) {
            return false;
        }
        if (holder.isSamePackage(context)) {
            return !clazz.accessFlags.isPrivate();
        }
        return clazz.accessFlags.isPublic() && target.accessFlags.isPublic();
    }
}

