/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import java.util.Map;
import java.util.Set;

public class RegisterMove
implements Comparable<RegisterMove> {
    final TypeLatticeElement type;
    final int dst;
    final int src;
    final Instruction definition;

    public RegisterMove(int dst, int src, TypeLatticeElement type) {
        this.dst = dst;
        this.src = src;
        this.definition = null;
        this.type = type;
    }

    public RegisterMove(int dst, TypeLatticeElement type, Instruction definition) {
        assert (definition.isOutConstant() || definition.isArgument());
        this.dst = dst;
        this.src = Integer.MIN_VALUE;
        this.definition = definition;
        this.type = type;
    }

    private boolean writes(int register) {
        if (this.type.isWide() && this.dst + 1 == register) {
            return true;
        }
        return this.dst == register;
    }

    public boolean isBlocked(Set<RegisterMove> moveSet, Map<Integer, Integer> valueMap) {
        for (RegisterMove move : moveSet) {
            if (move.src == Integer.MIN_VALUE || move == this) continue;
            if (this.writes(valueMap.get(move.src))) {
                return true;
            }
            if (!move.type.isWide() || !this.writes(valueMap.get(move.src) + 1)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.src + this.dst * 3 + this.type.hashCode() * 5 + (this.definition == null ? 0 : this.definition.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegisterMove)) {
            return false;
        }
        RegisterMove o = (RegisterMove)other;
        return o.src == this.src && o.dst == this.dst && o.type == this.type && o.definition == this.definition;
    }

    @Override
    public int compareTo(RegisterMove o) {
        int srcDiff = this.src - o.src;
        if (srcDiff != 0) {
            return srcDiff;
        }
        int dstDiff = this.dst - o.dst;
        if (dstDiff != 0) {
            return dstDiff;
        }
        if (this.type.isPrimitive() != o.type.isPrimitive()) {
            return Boolean.compare(this.type.isPrimitive(), o.type.isPrimitive());
        }
        if (this.type.isWide() != o.type.isWide()) {
            return Boolean.compare(this.type.isWide(), o.type.isWide());
        }
        if (this.type.isReference() != o.type.isReference()) {
            return Boolean.compare(this.type.isReference(), o.type.isReference());
        }
        if (this.definition == null) {
            if (o.definition != null) {
                return -1;
            }
            return 0;
        }
        if (o.definition == null) {
            return 1;
        }
        return this.definition.getNumber() - o.definition.getNumber();
    }
}

