/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.ClassMergingRule;
import com.android.tools.r8.shaking.ConstantArgumentRule;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepPackageNamesRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import com.android.tools.r8.shaking.UnusedArgumentRule;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RootSetBuilder {
    private final AppView<? extends AppInfo> appView;
    private final DirectMappedDexApplication application;
    private final Iterable<? extends ProguardConfigurationRule> rules;
    private final Map<DexDefinition, Set<ProguardKeepRule>> noShrinking = new IdentityHashMap<DexDefinition, Set<ProguardKeepRule>>();
    private final Set<DexDefinition> noOptimization = Sets.newIdentityHashSet();
    private final Set<DexDefinition> noObfuscation = Sets.newIdentityHashSet();
    private final LinkedHashMap<DexDefinition, DexDefinition> reasonAsked = new LinkedHashMap();
    private final Set<DexDefinition> keepPackageName = Sets.newIdentityHashSet();
    private final Set<ProguardConfigurationRule> rulesThatUseExtendsOrImplementsWrong = Sets.newIdentityHashSet();
    private final Set<DexDefinition> checkDiscarded = Sets.newIdentityHashSet();
    private final Set<DexMethod> alwaysInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> forceInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> neverInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepParametersWithConstantValue = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepUnusedArguments = Sets.newIdentityHashSet();
    private final Set<DexType> neverClassInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverMerge = Sets.newIdentityHashSet();
    private final Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentNoShrinking = new IdentityHashMap<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>>();
    private final Map<DexDefinition, ProguardMemberRule> noSideEffects = new IdentityHashMap<DexDefinition, ProguardMemberRule>();
    private final Map<DexDefinition, ProguardMemberRule> assumedValues = new IdentityHashMap<DexDefinition, ProguardMemberRule>();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final InternalOptions options;
    private final DexStringCache dexStringCache = new DexStringCache();
    private final Set<ProguardIfRule> ifRules = Sets.newIdentityHashSet();

    public RootSetBuilder(AppView<? extends AppInfo> appView, DexApplication application, Iterable<? extends ProguardConfigurationRule> rules, InternalOptions options) {
        this.appView = appView;
        this.application = application.asDirect();
        this.rules = rules;
        this.options = options;
    }

    RootSetBuilder(AppView<? extends AppInfo> appView, Collection<ProguardIfRule> ifRules, InternalOptions options) {
        this(appView, appView.appInfo().app, ifRules, options);
    }

    private void process(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        if (!this.satisfyClassType(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAnnotation(rule, clazz)) {
            return;
        }
        if (rule.hasInheritanceClassName() && !this.satisfyInheritanceRule(clazz, rule)) {
            return;
        }
        if (rule.getClassNames().matches(clazz.type)) {
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                if (clazz.isLibraryClass()) {
                    return;
                }
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule);
                        HashMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = new HashMap<Predicate<DexDefinition>, DexDefinition>();
                        if (ifRule != null) {
                            preconditionSupplier.put(DexDefinition::isStaticMember, null);
                            preconditionSupplier.put(definition -> !definition.isStaticMember(), clazz);
                        } else {
                            preconditionSupplier.put(definition -> true, null);
                        }
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        break;
                    }
                    case CONDITIONAL: {
                        throw new Unreachable("-if rule will be evaluated separately, not here.");
                    }
                }
            } else {
                if (rule instanceof ProguardIfRule) {
                    throw new Unreachable("-if rule will be evaluated separately, not here.");
                }
                if (rule instanceof ProguardCheckDiscardRule) {
                    if (memberKeepRules.isEmpty()) {
                        this.markClass(clazz, rule);
                    } else {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingFields(clazz, memberKeepRules, rule, preconditionSupplier);
                        this.markMatchingMethods(clazz, memberKeepRules, rule, preconditionSupplier);
                    }
                } else if (rule instanceof ProguardWhyAreYouKeepingRule || rule instanceof ProguardKeepPackageNamesRule) {
                    this.markClass(clazz, rule);
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else if (rule instanceof ProguardAssumeNoSideEffectRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else if (rule instanceof ClassMergingRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof InlineRule || rule instanceof ConstantArgumentRule || rule instanceof UnusedArgumentRule) {
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                } else if (rule instanceof ClassInlineRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof ProguardAssumeValuesRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else {
                    assert (rule instanceof ProguardIdentifierNameStringRule);
                    this.markMatchingFields(clazz, memberKeepRules, rule, null);
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                }
            }
        }
    }

    private void runPerRule(ExecutorService executorService, List<Future<?>> futures, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        List<DexType> specifics = rule.getClassNames().asSpecificDexTypes();
        if (specifics != null) {
            for (DexType type : specifics) {
                DexClass clazz = this.application.definitionFor(type);
                if (clazz == null) continue;
                this.process(clazz, rule, ifRule);
            }
        } else {
            futures.add(executorService.submit(() -> {
                for (DexProgramClass dexProgramClass : this.application.classes()) {
                    this.process(dexProgramClass, rule, ifRule);
                }
                if (rule.applyToLibraryClasses()) {
                    for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                        this.process(dexLibraryClass, rule, ifRule);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSet run(ExecutorService executorService) throws ExecutionException {
        this.application.timing.begin("Build root set...");
        try {
            ArrayList futures = new ArrayList();
            if (this.rules != null) {
                for (ProguardConfigurationRule proguardConfigurationRule : this.rules) {
                    if (proguardConfigurationRule instanceof ProguardIfRule) {
                        ProguardIfRule ifRule = (ProguardIfRule)proguardConfigurationRule;
                        this.ifRules.add(ifRule);
                        continue;
                    }
                    this.runPerRule(executorService, futures, proguardConfigurationRule, null);
                }
                ThreadUtils.awaitFutures(futures);
            }
        }
        finally {
            this.application.timing.end();
        }
        return new RootSet(this.noShrinking, this.noOptimization, this.noObfuscation, ImmutableList.copyOf(this.reasonAsked.values()), this.keepPackageName, this.checkDiscarded, this.alwaysInline, this.forceInline, this.neverInline, this.keepParametersWithConstantValue, this.keepUnusedArguments, this.neverClassInline, this.neverMerge, this.noSideEffects, this.assumedValues, this.dependentNoShrinking, this.identifierNameStrings, this.ifRules);
    }

    IfRuleEvaluator getIfRuleEvaluator(Set<DexEncodedField> liveFields, Set<DexEncodedMethod> liveMethods, Set<DexEncodedMethod> targetedMethods, ExecutorService executorService) {
        return new IfRuleEvaluator(liveFields, liveMethods, targetedMethods, executorService);
    }

    private static DexDefinition testAndGetPrecondition(DexDefinition definition, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        if (preconditionSupplier == null) {
            return null;
        }
        DexDefinition precondition = null;
        boolean conditionEverMatched = false;
        for (Map.Entry<Predicate<DexDefinition>, DexDefinition> entry : preconditionSupplier.entrySet()) {
            if (!entry.getKey().test(definition)) continue;
            precondition = entry.getValue();
            conditionEverMatched = true;
            break;
        }
        assert (conditionEverMatched);
        return precondition;
    }

    private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses) {
        HashSet methodsMarked = this.options.forceProguardCompatibility ? null : new HashSet();
        DexClass startingClass = clazz;
        while (clazz != null) {
            if (!includeLibraryClasses && clazz.isLibraryClass()) {
                return;
            }
            if (clazz == startingClass || this.options.forceProguardCompatibility) {
                Arrays.stream(clazz.directMethods()).forEach(method -> {
                    DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                    this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
                });
            }
            Arrays.stream(clazz.virtualMethods()).forEach(method -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachMethod(method -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
            this.markMethod((DexEncodedMethod)method, memberKeepRules, null, rule, precondition);
        });
    }

    private void markMatchingVisibleFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses) {
        while (clazz != null) {
            if (!includeLibraryClasses && clazz.isLibraryClass()) {
                return;
            }
            clazz.forEachField(field -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
                this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachField(field -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
            this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
        });
    }

    public static void writeSeeds(Enqueuer.AppInfoWithLiveness appInfo, PrintStream out, Predicate<DexType> include) {
        for (DexReference seed : appInfo.getPinnedItems()) {
            if (seed.isDexType()) {
                if (!include.test(seed.asDexType())) continue;
                out.println(seed.toSourceString());
                continue;
            }
            if (seed.isDexField()) {
                DexField field = seed.asDexField();
                if (!include.test(field.clazz)) continue;
                out.println(field.clazz.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                continue;
            }
            assert (seed.isDexMethod());
            DexMethod method = seed.asDexMethod();
            if (!include.test(method.holder)) continue;
            out.print(method.holder.toSourceString() + ": ");
            DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
            if (encodedMethod.accessFlags.isConstructor()) {
                if (encodedMethod.accessFlags.isStatic()) {
                    out.print("<clinit>");
                } else {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName);
                }
            } else {
                out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString());
            }
            boolean first = true;
            out.print("(");
            for (DexType param : method.proto.parameters.values) {
                if (!first) {
                    out.print(",");
                }
                first = false;
                out.print(param.toSourceString());
            }
            out.println(")");
        }
        out.close();
    }

    private boolean satisfyClassType(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassType().matches(clazz) != rule.getClassTypeNegated();
    }

    private static boolean satisfyAccessFlag(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassAccessFlags().containsAll(clazz.accessFlags) && rule.getNegatedClassAccessFlags().containsNone(clazz.accessFlags);
    }

    private static boolean satisfyAnnotation(ProguardConfigurationRule rule, DexClass clazz) {
        return RootSetBuilder.containsAnnotation(rule.getClassAnnotation(), clazz.annotations);
    }

    private boolean satisfyInheritanceRule(DexClass clazz, ProguardConfigurationRule rule) {
        boolean extendsExpected = this.satisfyExtendsRule(clazz, rule);
        boolean implementsExpected = false;
        if (!extendsExpected) {
            implementsExpected = this.satisfyImplementsRule(clazz, rule);
        }
        if (extendsExpected || implementsExpected) {
            if (rule.getInheritanceClassName().matchesSpecificType()) {
                if (rule.getInheritanceIsExtends()) {
                    if (implementsExpected && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                        assert (this.options.testing.allowProguardRulesThatUseExtendsOrImplementsWrong);
                        this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses extends but actually matches implements."));
                    }
                } else if (extendsExpected && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                    assert (this.options.testing.allowProguardRulesThatUseExtendsOrImplementsWrong);
                    this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses implements but actually matches extends."));
                }
            }
            return true;
        }
        return false;
    }

    private boolean satisfyExtendsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anySuperTypeMatchesExtendsRule(clazz.superType, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, false);
    }

    private boolean anySuperTypeMatchesExtendsRule(DexType type, ProguardConfigurationRule rule) {
        while (type != null) {
            DexClass clazz = this.application.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(clazz.type, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), clazz.annotations)) {
                return true;
            }
            type = clazz.superType;
        }
        return false;
    }

    private boolean satisfyImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anyImplementedInterfaceMatchesImplementsRule(clazz, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, true);
    }

    private boolean anyImplementedInterfaceMatchesImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (clazz == null) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = this.application.definitionFor(iface);
            if (ifaceClass == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(iface, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), ifaceClass.annotations)) {
                return true;
            }
            if (!this.anyImplementedInterfaceMatchesImplementsRule(ifaceClass, rule)) continue;
            return true;
        }
        if (clazz.superType == null) {
            return false;
        }
        DexClass superClass = this.application.definitionFor(clazz.superType);
        if (superClass == null) {
            return false;
        }
        return this.anyImplementedInterfaceMatchesImplementsRule(superClass, rule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anySourceMatchesInheritanceRuleDirectly(DexClass clazz, ProguardConfigurationRule rule, boolean isInterface) {
        if (this.appView.verticallyMergedClasses() == null) return false;
        if (!this.appView.verticallyMergedClasses().getSourcesFor(clazz.type).stream().filter(sourceType -> this.appView.appInfo().definitionFor((DexType)sourceType).accessFlags.isInterface() == isInterface).anyMatch(rule.getInheritanceClassName()::matches)) return false;
        return true;
    }

    private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
        for (ProguardMemberRule rule : memberKeepRules) {
            if (this.ruleSatisfied(rule, clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
        return this.ruleSatisfiedByMethods(rule, clazz.directMethods()) || this.ruleSatisfiedByMethods(rule, clazz.virtualMethods()) || this.ruleSatisfiedByFields(rule, clazz.staticFields()) || this.ruleSatisfiedByFields(rule, clazz.instanceFields());
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, Iterable<DexEncodedMethod> methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, DexEncodedMethod[] methods) {
        return this.ruleSatisfiedByMethods(rule, Arrays.asList(methods));
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, Iterable<DexEncodedField> fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, DexEncodedField[] fields) {
        return this.ruleSatisfiedByFields(rule, Arrays.asList(fields));
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexAnnotationSet annotations) {
        if (classAnnotation == null) {
            return true;
        }
        if (annotations.isEmpty()) {
            return false;
        }
        for (DexAnnotation annotation : annotations.annotations) {
            if (!classAnnotation.matches(annotation.annotation.type)) continue;
            return true;
        }
        return false;
    }

    private void markMethod(DexEncodedMethod method, Collection<ProguardMemberRule> rules, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, ProguardConfigurationRule context, DexDefinition precondition) {
        if (methodsMarked != null && methodsMarked.contains(MethodSignatureEquivalence.get().wrap(method.method))) {
            return;
        }
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
            Log.debug(this.getClass(), "Marking method `%s` due to `%s { %s }`.", method, context, rule);
            if (methodsMarked != null) {
                methodsMarked.add(MethodSignatureEquivalence.get().wrap(method.method));
            }
            this.addItemToSets(method, context, rule, precondition);
        }
    }

    private void markField(DexEncodedField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexDefinition precondition) {
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
            Log.debug(this.getClass(), "Marking field `%s` due to `%s { %s }`.", field, context, rule);
            this.addItemToSets(field, context, rule, precondition);
        }
    }

    private void markClass(DexClass clazz, ProguardConfigurationRule rule) {
        Log.debug(this.getClass(), "Marking class `%s` due to `%s`.", clazz.type, rule);
        this.addItemToSets(clazz, rule, null, null);
    }

    private void includeDescriptor(DexDefinition item, DexType type, ProguardKeepRule context) {
        if (type.isVoidType()) {
            return;
        }
        if (type.isArrayType()) {
            type = type.toBaseType(this.application.dexItemFactory);
        }
        if (type.isPrimitiveType()) {
            return;
        }
        DexClass definition = this.appView.appInfo().definitionFor(type);
        if (definition == null || definition.isLibraryClass()) {
            return;
        }
        this.dependentNoShrinking.computeIfAbsent(item, x -> new IdentityHashMap()).computeIfAbsent(definition, k -> new HashSet()).add(context);
        this.noObfuscation.add(definition);
    }

    private void includeDescriptorClasses(DexDefinition item, ProguardKeepRule context) {
        if (item.isDexEncodedMethod()) {
            DexMethod method = item.asDexEncodedMethod().method;
            this.includeDescriptor(item, method.proto.returnType, context);
            for (DexType value : method.proto.parameters.values) {
                this.includeDescriptor(item, value, context);
            }
        } else if (item.isDexEncodedField()) {
            DexField field = item.asDexEncodedField().field;
            this.includeDescriptor(item, field.type, context);
        } else assert (item.isDexClass());
    }

    private synchronized void addItemToSets(DexDefinition item, ProguardConfigurationRule context, ProguardMemberRule rule, DexDefinition precondition) {
        block30: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block29: {
                                                if (!(context instanceof ProguardKeepRule)) break block29;
                                                if (item.isDexEncodedMethod() && item.asDexEncodedMethod().accessFlags.isSynthetic()) {
                                                    return;
                                                }
                                                ProguardKeepRule keepRule = (ProguardKeepRule)context;
                                                ProguardKeepRuleModifiers modifiers = keepRule.getModifiers();
                                                if (!modifiers.allowsShrinking) {
                                                    if (precondition != null) {
                                                        this.dependentNoShrinking.computeIfAbsent(precondition, x -> new IdentityHashMap()).computeIfAbsent(item, i -> new HashSet()).add(keepRule);
                                                    } else {
                                                        this.noShrinking.computeIfAbsent(item, i -> new HashSet()).add(keepRule);
                                                    }
                                                }
                                                if (!modifiers.allowsOptimization) {
                                                    this.noOptimization.add(item);
                                                }
                                                if (!modifiers.allowsObfuscation) {
                                                    this.noObfuscation.add(item);
                                                }
                                                if (modifiers.includeDescriptorClasses) {
                                                    this.includeDescriptorClasses(item, keepRule);
                                                }
                                                break block30;
                                            }
                                            if (!(context instanceof ProguardAssumeNoSideEffectRule)) break block31;
                                            this.noSideEffects.put(item, rule);
                                            break block30;
                                        }
                                        if (!(context instanceof ProguardWhyAreYouKeepingRule)) break block32;
                                        this.reasonAsked.computeIfAbsent(item, i -> i);
                                        break block30;
                                    }
                                    if (!(context instanceof ProguardKeepPackageNamesRule)) break block33;
                                    this.keepPackageName.add(item);
                                    break block30;
                                }
                                if (!(context instanceof ProguardAssumeValuesRule)) break block34;
                                this.assumedValues.put(item, rule);
                                break block30;
                            }
                            if (!(context instanceof ProguardCheckDiscardRule)) break block35;
                            this.checkDiscarded.add(item);
                            break block30;
                        }
                        if (!(context instanceof InlineRule)) break block36;
                        if (!item.isDexEncodedMethod()) break block30;
                        switch (((InlineRule)context).getType()) {
                            case ALWAYS: {
                                this.alwaysInline.add(item.asDexEncodedMethod().method);
                                break block30;
                            }
                            case FORCE: {
                                this.forceInline.add(item.asDexEncodedMethod().method);
                                break block30;
                            }
                            case NEVER: {
                                this.neverInline.add(item.asDexEncodedMethod().method);
                                break block30;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                    }
                    if (!(context instanceof ClassInlineRule)) break block37;
                    switch (((ClassInlineRule)context).getType()) {
                        case NEVER: {
                            if (item.isDexClass()) {
                                this.neverClassInline.add(item.asDexClass().type);
                            }
                            break block30;
                        }
                        default: {
                            throw new Unreachable();
                        }
                    }
                }
                if (!(context instanceof ClassMergingRule)) break block38;
                switch (((ClassMergingRule)context).getType()) {
                    case NEVER: {
                        if (item.isDexClass()) {
                            this.neverMerge.add(item.asDexClass().type);
                        }
                        break block30;
                    }
                    default: {
                        throw new Unreachable();
                    }
                }
            }
            if (context instanceof ProguardIdentifierNameStringRule) {
                if (item.isDexEncodedField()) {
                    this.identifierNameStrings.add(item.asDexEncodedField().field);
                } else if (item.isDexEncodedMethod()) {
                    this.identifierNameStrings.add(item.asDexEncodedMethod().method);
                }
            } else if (context instanceof ConstantArgumentRule) {
                if (item.isDexEncodedMethod()) {
                    this.keepParametersWithConstantValue.add(item.asDexEncodedMethod().method);
                }
            } else if (context instanceof UnusedArgumentRule && item.isDexEncodedMethod()) {
                this.keepUnusedArguments.add(item.asDexEncodedMethod().method);
            }
        }
    }

    static class ConsequentRootSet {
        final Set<DexMethod> neverInline;
        final Set<DexType> neverClassInline;
        final Map<DexDefinition, Set<ProguardKeepRule>> noShrinking;
        final Set<DexDefinition> noOptimization;
        final Set<DexDefinition> noObfuscation;
        final Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentNoShrinking;

        private ConsequentRootSet(Set<DexMethod> neverInline, Set<DexType> neverClassInline, Map<DexDefinition, Set<ProguardKeepRule>> noShrinking, Set<DexDefinition> noOptimization, Set<DexDefinition> noObfuscation, Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentNoShrinking) {
            this.neverInline = Collections.unmodifiableSet(neverInline);
            this.neverClassInline = Collections.unmodifiableSet(neverClassInline);
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = Collections.unmodifiableSet(noOptimization);
            this.noObfuscation = Collections.unmodifiableSet(noObfuscation);
            this.dependentNoShrinking = Collections.unmodifiableMap(dependentNoShrinking);
        }
    }

    public static class RootSet {
        public final Map<DexDefinition, Set<ProguardKeepRule>> noShrinking;
        public final Set<DexDefinition> noOptimization;
        public final Set<DexDefinition> noObfuscation;
        public final ImmutableList<DexDefinition> reasonAsked;
        public final Set<DexDefinition> keepPackageName;
        public final Set<DexDefinition> checkDiscarded;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> forceInline;
        public final Set<DexMethod> neverInline;
        public final Set<DexMethod> keepConstantArguments;
        public final Set<DexMethod> keepUnusedArguments;
        public final Set<DexType> neverClassInline;
        public final Set<DexType> neverMerge;
        public final Map<DexDefinition, ProguardMemberRule> noSideEffects;
        public final Map<DexDefinition, ProguardMemberRule> assumedValues;
        private final Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentNoShrinking;
        public final Set<DexReference> identifierNameStrings;
        public final Set<ProguardIfRule> ifRules;

        private RootSet(Map<DexDefinition, Set<ProguardKeepRule>> noShrinking, Set<DexDefinition> noOptimization, Set<DexDefinition> noObfuscation, ImmutableList<DexDefinition> reasonAsked, Set<DexDefinition> keepPackageName, Set<DexDefinition> checkDiscarded, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> neverClassInline, Set<DexType> neverMerge, Map<DexDefinition, ProguardMemberRule> noSideEffects, Map<DexDefinition, ProguardMemberRule> assumedValues, Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentNoShrinking, Set<DexReference> identifierNameStrings, Set<ProguardIfRule> ifRules) {
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = noOptimization;
            this.noObfuscation = noObfuscation;
            this.reasonAsked = reasonAsked;
            this.keepPackageName = Collections.unmodifiableSet(keepPackageName);
            this.checkDiscarded = Collections.unmodifiableSet(checkDiscarded);
            this.alwaysInline = Collections.unmodifiableSet(alwaysInline);
            this.forceInline = Collections.unmodifiableSet(forceInline);
            this.neverInline = neverInline;
            this.keepConstantArguments = keepConstantArguments;
            this.keepUnusedArguments = keepUnusedArguments;
            this.neverClassInline = neverClassInline;
            this.neverMerge = Collections.unmodifiableSet(neverMerge);
            this.noSideEffects = Collections.unmodifiableMap(noSideEffects);
            this.assumedValues = Collections.unmodifiableMap(assumedValues);
            this.dependentNoShrinking = dependentNoShrinking;
            this.identifierNameStrings = Collections.unmodifiableSet(identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(ifRules);
        }

        void addDependentItems(Map<DexDefinition, Map<DexDefinition, Set<ProguardKeepRule>>> dependentItems) {
            dependentItems.forEach((def, dependence) -> this.dependentNoShrinking.computeIfAbsent((DexDefinition)def, x -> new IdentityHashMap()).putAll(dependence));
        }

        Map<DexDefinition, Set<ProguardKeepRule>> getDependentItems(DexDefinition item) {
            return Collections.unmodifiableMap(this.dependentNoShrinking.getOrDefault(item, Collections.emptyMap()));
        }

        public boolean verifyKeptFieldsAreAccessedAndLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexDefinition definition : this.noShrinking.keySet()) {
                DexEncodedField field;
                if (definition.isDexEncodedField() && ((field = definition.asDexEncodedField()).isStatic() || this.isKeptDirectlyOrIndirectly(field.field.clazz, appInfo))) assert (appInfo.liveFields.contains(field.field)) : "Expected kept field `" + field.field.toSourceString() + "` to be live";
            }
            return true;
        }

        public boolean verifyKeptMethodsAreTargetedAndLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexDefinition definition : this.noShrinking.keySet()) {
                if (!definition.isDexEncodedMethod()) continue;
                DexEncodedMethod method = definition.asDexEncodedMethod();
                assert (appInfo.targetedMethods.contains(method.method)) : "Expected kept method `" + method.method.toSourceString() + "` to be targeted";
                if (!method.accessFlags.isAbstract() && this.isKeptDirectlyOrIndirectly(method.method.holder, appInfo)) assert (appInfo.liveMethods.contains(method.method)) : "Expected non-abstract kept method `" + method.method.toSourceString() + "` to be live";
            }
            return true;
        }

        public boolean verifyKeptTypesAreLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexDefinition definition : this.noShrinking.keySet()) {
                if (!definition.isDexClass()) continue;
                DexClass clazz = definition.asDexClass();
                assert (appInfo.liveTypes.contains(clazz.type)) : "Expected kept type `" + clazz.type.toSourceString() + "` to be live";
            }
            return true;
        }

        private boolean isKeptDirectlyOrIndirectly(DexType type, Enqueuer.AppInfoWithLiveness appInfo) {
            DexClass clazz = appInfo.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (this.noShrinking.containsKey(clazz)) {
                return true;
            }
            if (clazz.superType != null) {
                return this.isKeptDirectlyOrIndirectly(clazz.superType, appInfo);
            }
            return false;
        }

        public boolean verifyKeptItemsAreKept(DexApplication application, AppInfo appInfo, InternalOptions options) {
            if (options.getProguardConfiguration().hasApplyMappingFile()) {
                return true;
            }
            boolean isInterfaceMethodDesugaringEnabled = options.enableDesugaring && options.interfaceMethodDesugaring == OffOrAuto.Auto && !options.canUseDefaultAndStaticInterfaceMethods();
            Set<DexReference> pinnedItems = appInfo.hasLiveness() ? appInfo.withLiveness().pinnedItems : null;
            IdentityHashMap<DexType, Set> requiredDefinitionsPerType = new IdentityHashMap<DexType, Set>();
            for (DexDefinition dexDefinition : this.noShrinking.keySet()) {
                assert (pinnedItems == null || pinnedItems.contains(dexDefinition.toReference()));
                if (dexDefinition.isDexClass()) {
                    DexType type = dexDefinition.toReference().asDexType();
                    requiredDefinitionsPerType.putIfAbsent(type, Sets.newIdentityHashSet());
                    continue;
                }
                assert (dexDefinition.isDexEncodedField() || dexDefinition.isDexEncodedMethod());
                Descriptor descriptor = dexDefinition.toReference().asDescriptor();
                requiredDefinitionsPerType.computeIfAbsent(descriptor.getHolder(), key -> Sets.newIdentityHashSet()).add(dexDefinition);
            }
            for (DexProgramClass dexProgramClass : application.classes()) {
                Set requiredDefinitions = requiredDefinitionsPerType.getOrDefault(dexProgramClass.type, ImmutableSet.of());
                Set fields = null;
                Set methods = null;
                for (DexDefinition requiredDefinition : requiredDefinitions) {
                    if (requiredDefinition.isDexEncodedField()) {
                        DexEncodedField requiredField = requiredDefinition.asDexEncodedField();
                        if (fields == null) {
                            fields = Streams.stream(dexProgramClass.fields()).map(DexEncodedField::getKey).collect(Collectors.toSet());
                        }
                        assert (fields.contains(requiredField.field));
                        continue;
                    }
                    if (requiredDefinition.isDexEncodedMethod()) {
                        DexEncodedMethod requiredMethod = requiredDefinition.asDexEncodedMethod();
                        if (isInterfaceMethodDesugaringEnabled && dexProgramClass.isInterface() && requiredMethod.hasCode()) continue;
                        if (methods == null) {
                            methods = Streams.stream(dexProgramClass.methods()).map(DexEncodedMethod::getKey).collect(Collectors.toSet());
                        }
                        assert (methods.contains(requiredMethod.method));
                        continue;
                    }
                    assert (false);
                }
                requiredDefinitionsPerType.remove(dexProgramClass.type);
            }
            if (!requiredDefinitionsPerType.isEmpty()) {
                DexType type = (DexType)requiredDefinitionsPerType.keySet().iterator().next();
                DexClass dexClass = application.definitionFor(type);
                assert (dexClass == null || dexClass.isProgramClass()) : "Unexpected library type in root set: `" + type + "`";
                assert (requiredDefinitionsPerType.isEmpty()) : "Expected type `" + type.toSourceString() + "` to be present";
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootSet");
            builder.append("\nnoShrinking: " + this.noShrinking.size());
            builder.append("\nnoOptimization: " + this.noOptimization.size());
            builder.append("\nnoObfuscation: " + this.noObfuscation.size());
            builder.append("\nreasonAsked: " + this.reasonAsked.size());
            builder.append("\nkeepPackageName: " + this.keepPackageName.size());
            builder.append("\ncheckDiscarded: " + this.checkDiscarded.size());
            builder.append("\nnoSideEffects: " + this.noSideEffects.size());
            builder.append("\nassumedValues: " + this.assumedValues.size());
            builder.append("\ndependentNoShrinking: " + this.dependentNoShrinking.size());
            builder.append("\nidentifierNameStrings: " + this.identifierNameStrings.size());
            builder.append("\nifRules: " + this.ifRules.size());
            builder.append("\n\nNo Shrinking:");
            this.noShrinking.keySet().stream().sorted(Comparator.comparing(DexItem::toSourceString)).forEach(a -> builder.append("\n").append(a.toSourceString()).append(" ").append(this.noShrinking.get(a)));
            builder.append("\n");
            return builder.toString();
        }
    }

    class IfRuleEvaluator {
        private final Set<DexEncodedField> liveFields;
        private final Set<DexEncodedMethod> liveMethods;
        private final Set<DexEncodedMethod> targetedMethods;
        private final ExecutorService executorService;
        private final List<Future<?>> futures = new ArrayList();

        public IfRuleEvaluator(Set<DexEncodedField> liveFields, Set<DexEncodedMethod> liveMethods, Set<DexEncodedMethod> targetedMethods, ExecutorService executorService) {
            this.liveFields = liveFields;
            this.liveMethods = liveMethods;
            this.targetedMethods = targetedMethods;
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConsequentRootSet run(Set<DexType> liveTypes) throws ExecutionException {
            ((RootSetBuilder)RootSetBuilder.this).application.timing.begin("Find consequent items for -if rules...");
            try {
                if (RootSetBuilder.this.rules != null) {
                    for (ProguardConfigurationRule rule : RootSetBuilder.this.rules) {
                        assert (rule instanceof ProguardIfRule);
                        ProguardIfRule ifRule = (ProguardIfRule)rule;
                        for (DexType type : liveTypes) {
                            DexClass clazz = ((AppInfo)RootSetBuilder.this.appView.appInfo()).definitionFor(type);
                            if (clazz == null) continue;
                            this.evaluateIfRule(ifRule, clazz, clazz);
                            if (!((RootSetBuilder)RootSetBuilder.this).options.enableVerticalClassMerging || RootSetBuilder.this.appView.verticallyMergedClasses() == null) continue;
                            for (DexType sourceType : RootSetBuilder.this.appView.verticallyMergedClasses().getSourcesFor(type)) {
                                DexClass sourceClass = ((AppInfo)RootSetBuilder.this.appView.appInfo()).definitionFor(sourceType);
                                assert (sourceClass != null);
                                this.evaluateIfRule(ifRule, sourceClass, clazz);
                            }
                        }
                    }
                    ThreadUtils.awaitFutures(this.futures);
                }
            }
            finally {
                ((RootSetBuilder)RootSetBuilder.this).application.timing.end();
            }
            return new ConsequentRootSet(RootSetBuilder.this.neverInline, RootSetBuilder.this.neverClassInline, RootSetBuilder.this.noShrinking, RootSetBuilder.this.noOptimization, RootSetBuilder.this.noObfuscation, RootSetBuilder.this.dependentNoShrinking);
        }

        private void evaluateIfRule(ProguardIfRule rule, DexClass sourceClass, DexClass targetClass) {
            if (!RootSetBuilder.this.satisfyClassType(rule, sourceClass)) {
                return;
            }
            if (!RootSetBuilder.satisfyAccessFlag(rule, sourceClass)) {
                return;
            }
            if (!RootSetBuilder.satisfyAnnotation(rule, sourceClass)) {
                return;
            }
            if (!rule.getClassNames().matches(sourceClass.type)) {
                return;
            }
            if (rule.hasInheritanceClassName() && !RootSetBuilder.this.satisfyInheritanceRule(targetClass, rule)) {
                return;
            }
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (memberKeepRules.isEmpty()) {
                this.materializeIfRule(rule);
                return;
            }
            Set filteredMembers = Sets.newIdentityHashSet();
            Iterables.addAll(filteredMembers, targetClass.fields(f -> this.liveFields.contains(f) && RootSetBuilder.this.appView.graphLense().getOriginalFieldSignature(f.field).getHolder() == sourceClass.type));
            Iterables.addAll(filteredMembers, targetClass.methods(m -> (this.liveMethods.contains(m) || this.targetedMethods.contains(m)) && RootSetBuilder.this.appView.graphLense().getOriginalMethodSignature(m.method).getHolder() == sourceClass.type));
            if (filteredMembers.size() < memberKeepRules.size()) {
                return;
            }
            Sets.combinations(filteredMembers, memberKeepRules.size()).forEach(combination -> {
                Collection fieldsInCombination = DexDefinition.filterDexEncodedField(combination.stream()).collect(Collectors.toList());
                Collection methodsInCombination = DexDefinition.filterDexEncodedMethod(combination.stream()).collect(Collectors.toList());
                boolean satisfied = memberKeepRules.stream().allMatch(memberRule -> RootSetBuilder.this.ruleSatisfiedByFields(memberRule, fieldsInCombination) || RootSetBuilder.this.ruleSatisfiedByMethods(memberRule, methodsInCombination));
                if (satisfied) {
                    this.materializeIfRule(rule);
                }
            });
        }

        private void materializeIfRule(ProguardIfRule rule) {
            InlineRule neverInlineRuleForCondition;
            ProguardIfRule materializedRule = rule.materialize();
            ClassInlineRule neverClassInlineRuleForCondition = materializedRule.neverClassInlineRuleForCondition();
            if (neverClassInlineRuleForCondition != null) {
                RootSetBuilder.this.runPerRule(this.executorService, this.futures, neverClassInlineRuleForCondition, materializedRule);
            }
            if ((neverInlineRuleForCondition = materializedRule.neverInlineRuleForCondition()) != null) {
                RootSetBuilder.this.runPerRule(this.executorService, this.futures, neverInlineRuleForCondition, materializedRule);
            }
            RootSetBuilder.this.runPerRule(this.executorService, this.futures, materializedRule.subsequentRule, materializedRule);
        }
    }
}

