/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DirectoryClassFileProvider;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.ArchiveResourceProvider;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.FilteredArchiveClassFileProvider;
import com.android.tools.r8.utils.InternalArchiveClassFileProvider;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidApp {
    private final ImmutableList<ProgramResourceProvider> programResourceProviders;
    private final ImmutableMap<Resource, String> programResourcesMainDescriptor;
    private final ImmutableList<ClassFileResourceProvider> classpathResourceProviders;
    private final ImmutableList<ClassFileResourceProvider> libraryResourceProviders;
    private final ImmutableList<InternalArchiveClassFileProvider> archiveProvidersToClose;
    private final StringResource proguardMapOutputData;
    private final List<StringResource> mainDexListResources;
    private final List<String> mainDexClasses;

    public void closeInternalArchiveProviders() throws IOException {
        for (InternalArchiveClassFileProvider provider : this.archiveProvidersToClose) {
            provider.close();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            if (!this.programResourceProviders.isEmpty()) {
                builder.append("  Program resources:").append(System.lineSeparator());
                AndroidApp.printProgramResourceProviders(builder, this.programResourceProviders);
            }
            if (!this.classpathResourceProviders.isEmpty()) {
                builder.append("  Classpath resources:").append(System.lineSeparator());
                AndroidApp.printClassFileProviders(builder, this.classpathResourceProviders);
            }
            if (!this.libraryResourceProviders.isEmpty()) {
                builder.append("  Library resources:").append(System.lineSeparator());
                AndroidApp.printClassFileProviders(builder, this.libraryResourceProviders);
            }
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    private static void printProgramResourceProviders(StringBuilder builder, Collection<ProgramResourceProvider> providers) throws ResourceException {
        for (ProgramResourceProvider provider : providers) {
            for (ProgramResource resource : provider.getProgramResources()) {
                AndroidApp.printProgramResource(builder, resource);
            }
        }
    }

    private static void printClassFileProviders(StringBuilder builder, Collection<ClassFileResourceProvider> providers) {
        for (ClassFileResourceProvider provider : providers) {
            for (String descriptor : provider.getClassDescriptors()) {
                ProgramResource resource = provider.getProgramResource(descriptor);
                AndroidApp.printProgramResource(builder, resource);
            }
        }
    }

    private static void printProgramResource(StringBuilder builder, ProgramResource resource) {
        builder.append("    ").append(resource.getOrigin());
        Set<String> descriptors = resource.getClassDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            builder.append(" contains ");
            StringUtils.append(builder, descriptors);
        }
        builder.append(System.lineSeparator());
    }

    private AndroidApp(ImmutableList<ProgramResourceProvider> programResourceProviders, ImmutableMap<Resource, String> programResourcesMainDescriptor, ImmutableList<ClassFileResourceProvider> classpathResourceProviders, ImmutableList<ClassFileResourceProvider> libraryResourceProviders, ImmutableList<InternalArchiveClassFileProvider> archiveProvidersToClose, StringResource proguardMapOutputData, List<StringResource> mainDexListResources, List<String> mainDexClasses) {
        this.programResourceProviders = programResourceProviders;
        this.programResourcesMainDescriptor = programResourcesMainDescriptor;
        this.classpathResourceProviders = classpathResourceProviders;
        this.libraryResourceProviders = libraryResourceProviders;
        this.archiveProvidersToClose = archiveProvidersToClose;
        this.proguardMapOutputData = proguardMapOutputData;
        this.mainDexListResources = mainDexListResources;
        this.mainDexClasses = mainDexClasses;
        assert (AndroidApp.verifyInternalProvidersInCloseSet(classpathResourceProviders, archiveProvidersToClose));
        assert (AndroidApp.verifyInternalProvidersInCloseSet(libraryResourceProviders, archiveProvidersToClose));
    }

    private static boolean verifyInternalProvidersInCloseSet(ImmutableList<ClassFileResourceProvider> providers, ImmutableList<InternalArchiveClassFileProvider> providersToClose) {
        return providers.stream().allMatch(p -> !(p instanceof InternalArchiveClassFileProvider) || providersToClose.contains(p));
    }

    static Reporter defaultReporter() {
        return new Reporter();
    }

    public static Builder builder() {
        return AndroidApp.builder(AndroidApp.defaultReporter());
    }

    public static Builder builder(Reporter reporter) {
        return new Builder(reporter);
    }

    public static Builder builder(AndroidApp app) {
        return AndroidApp.builder(app, AndroidApp.defaultReporter());
    }

    public static Builder builder(AndroidApp app, Reporter reporter) {
        return new Builder(reporter, app);
    }

    public Collection<ProgramResource> computeAllProgramResources() throws ResourceException {
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : this.programResourceProviders) {
            resources.addAll(provider.getProgramResources());
        }
        return resources;
    }

    public List<ProgramResource> getDexProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.DEX);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public List<ProgramResource> getClassProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.CF);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public List<ProgramResourceProvider> getProgramResourceProviders() {
        return this.programResourceProviders;
    }

    public List<ClassFileResourceProvider> getClasspathResourceProviders() {
        return this.classpathResourceProviders;
    }

    public List<ClassFileResourceProvider> getLibraryResourceProviders() {
        return this.libraryResourceProviders;
    }

    private List<ProgramResource> filter(List<ProgramResourceProvider> providers, ProgramResource.Kind kind) throws ResourceException {
        ArrayList<ProgramResource> out = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : providers) {
            for (ProgramResource code : provider.getProgramResources()) {
                if (code.getKind() != kind) continue;
                out.add(code);
            }
        }
        return out;
    }

    public StringResource getProguardMapOutputData() {
        return this.proguardMapOutputData;
    }

    public boolean hasMainDexList() {
        return !this.mainDexListResources.isEmpty() || !this.mainDexClasses.isEmpty();
    }

    public boolean hasMainDexListResources() {
        return !this.mainDexListResources.isEmpty();
    }

    public List<StringResource> getMainDexListResources() {
        return this.mainDexListResources;
    }

    public List<String> getMainDexClasses() {
        return this.mainDexClasses;
    }

    public void write(Path output, OutputMode outputMode) throws IOException {
        if (FileUtils.isArchive(output)) {
            this.writeToZip(output, outputMode);
        } else {
            this.writeToDirectory(output, outputMode);
        }
    }

    public void writeToDirectory(Path directory, OutputMode outputMode) throws IOException {
        List<ProgramResource> dexProgramSources = this.getDexProgramResourcesForTesting();
        try {
            if (outputMode == OutputMode.DexIndexed) {
                DexIndexedConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources);
            } else {
                DexFilePerClassFileConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources, this.programResourcesMainDescriptor);
            }
        }
        catch (ResourceException e) {
            throw new IOException("Resource Error", e);
        }
    }

    public void writeToZip(Path archive, OutputMode outputMode) throws IOException {
        block5: {
            try {
                if (outputMode == OutputMode.DexIndexed) {
                    List<ProgramResource> resources = this.getDexProgramResourcesForTesting();
                    DexIndexedConsumer.ArchiveConsumer.writeResources(archive, resources);
                    break block5;
                }
                if (outputMode == OutputMode.DexFilePerClassFile) {
                    List<ProgramResource> resources = this.getDexProgramResourcesForTesting();
                    DexFilePerClassFileConsumer.ArchiveConsumer.writeResources(archive, resources, this.programResourcesMainDescriptor);
                    break block5;
                }
                if (outputMode == OutputMode.ClassFile) {
                    List<ProgramResource> resources = this.getClassProgramResourcesForTesting();
                    ClassFileConsumer.ArchiveConsumer.writeResources(archive, resources);
                    break block5;
                }
                throw new Unreachable("Unsupported output-mode for writing: " + (Object)((Object)outputMode));
            }
            catch (ResourceException e) {
                throw new IOException("Resource Error", e);
            }
        }
    }

    public String getPrimaryClassDescriptor(Resource resource) {
        assert (resource instanceof ProgramResource);
        return this.programResourcesMainDescriptor.get(resource);
    }

    public static class Builder {
        private final List<ProgramResourceProvider> programResourceProviders = new ArrayList<ProgramResourceProvider>();
        private final List<ProgramResource> programResources = new ArrayList<ProgramResource>();
        private final List<DataResource> dataResources = new ArrayList<DataResource>();
        private final Map<ProgramResource, String> programResourcesMainDescriptor = new HashMap<ProgramResource, String>();
        private final List<ClassFileResourceProvider> classpathResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<ClassFileResourceProvider> libraryResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<InternalArchiveClassFileProvider> archiveProvidersToClose = new ArrayList<InternalArchiveClassFileProvider>();
        private List<StringResource> mainDexListResources = new ArrayList<StringResource>();
        private List<String> mainDexListClasses = new ArrayList<String>();
        private boolean ignoreDexInArchive = false;
        private StringResource proguardMapOutputData;
        private final Reporter reporter;

        private Builder(Reporter reporter) {
            this.reporter = reporter;
        }

        private Builder(Reporter reporter, AndroidApp app) {
            this(reporter);
            this.programResourceProviders.addAll(app.programResourceProviders);
            this.classpathResourceProviders.addAll(app.classpathResourceProviders);
            this.libraryResourceProviders.addAll(app.libraryResourceProviders);
            this.archiveProvidersToClose.addAll(app.archiveProvidersToClose);
            this.mainDexListResources = app.mainDexListResources;
            this.mainDexListClasses = app.mainDexClasses;
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public Builder addProgramFiles(Path ... files) {
            return this.addProgramFiles(Arrays.asList(files));
        }

        public Builder addProgramFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addProgramFile(file);
            }
            return this;
        }

        public Builder addFilteredProgramArchives(Collection<FilteredClassPath> filteredArchives) {
            for (FilteredClassPath archive : filteredArchives) {
                assert (FileUtils.isArchive(archive.getPath()));
                ArchiveResourceProvider archiveResourceProvider = new ArchiveResourceProvider(archive, this.ignoreDexInArchive);
                this.addProgramResourceProvider(archiveResourceProvider);
            }
            return this;
        }

        public Builder addProgramResourceProvider(ProgramResourceProvider provider) {
            assert (provider != null);
            this.programResourceProviders.add(provider);
            return this;
        }

        public Builder addClasspathFiles(Path ... files) {
            return this.addClasspathFiles(Arrays.asList(files));
        }

        public Builder addClasspathFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addClasspathFile(file);
            }
            return this;
        }

        public Builder addClasspathFile(Path file) {
            this.addClasspathOrLibraryProvider(file, this.classpathResourceProviders);
            return this;
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.classpathResourceProviders.add(provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) {
            return this.addLibraryFiles(Arrays.asList(files));
        }

        public Builder addLibraryFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            }
            return this;
        }

        public Builder addLibraryFile(Path file) {
            this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            return this;
        }

        public Builder addFilteredLibraryArchives(Collection<FilteredClassPath> filteredArchives) {
            for (FilteredClassPath archive : filteredArchives) {
                assert (FileUtils.isArchive(archive.getPath()));
                try {
                    FilteredArchiveClassFileProvider provider = new FilteredArchiveClassFileProvider(archive);
                    this.archiveProvidersToClose.add(provider);
                    this.libraryResourceProviders.add(provider);
                }
                catch (IOException e) {
                    this.reporter.error(new ExceptionDiagnostic(e, new PathOrigin(archive.getPath())));
                }
            }
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.libraryResourceProviders.add(provider);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, classDescriptors));
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors, String primaryClassDescriptor) {
            ProgramResource resource = ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data, classDescriptors);
            this.programResources.add(resource);
            this.programResourcesMainDescriptor.put(resource, primaryClassDescriptor);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.DEX, data, null));
            return this;
        }

        public Builder addDexProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, datum, null));
            }
            return this;
        }

        public Builder addClassProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addClassProgramData(datum, Origin.unknown());
            }
            return this;
        }

        public Builder addClassProgramData(byte[] data, Origin origin) {
            return this.addClassProgramData(data, origin, null);
        }

        public Builder addClassProgramData(byte[] data, Origin origin, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.CF, data, classDescriptors));
            return this;
        }

        public Builder addDataResource(DataResource dataResource) {
            this.addDataResources(dataResource);
            return this;
        }

        public Builder setProguardMapOutputData(String content) {
            this.proguardMapOutputData = content == null ? null : StringResource.fromString(content, Origin.unknown());
            return this;
        }

        public Builder addMainDexListFiles(Path ... files) throws NoSuchFileException {
            return this.addMainDexListFiles(Arrays.asList(files));
        }

        public Builder addMainDexListFiles(Collection<Path> files) throws NoSuchFileException {
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new NoSuchFileException(file.toString());
                }
                this.mainDexListResources.add(StringResource.fromFile(file));
            }
            return this;
        }

        public Builder addMainDexClasses(String ... classes) {
            return this.addMainDexClasses(Arrays.asList(classes));
        }

        public Builder addMainDexClasses(Collection<String> classes) {
            this.mainDexListClasses.addAll(classes);
            return this;
        }

        public boolean hasMainDexList() {
            return !this.mainDexListResources.isEmpty() || !this.mainDexListClasses.isEmpty();
        }

        public Builder setIgnoreDexInArchive(boolean value) {
            this.ignoreDexInArchive = value;
            return this;
        }

        public AndroidApp build() {
            if (!this.programResources.isEmpty() || !this.dataResources.isEmpty()) {
                final ImmutableList<ProgramResource> finalProgramResources = ImmutableList.copyOf(this.programResources);
                final ImmutableList<DataResource> finalDataResources = ImmutableList.copyOf(this.dataResources);
                this.programResourceProviders.add(new ProgramResourceProvider(){

                    @Override
                    public Collection<ProgramResource> getProgramResources() {
                        return finalProgramResources;
                    }

                    @Override
                    public DataResourceProvider getDataResourceProvider() {
                        if (!finalDataResources.isEmpty()) {
                            return new DataResourceProvider(){

                                @Override
                                public void accept(DataResourceProvider.Visitor visitor) {
                                    for (DataResource dataResource : finalDataResources) {
                                        if (dataResource instanceof DataEntryResource) {
                                            visitor.visit((DataEntryResource)dataResource);
                                            continue;
                                        }
                                        assert (dataResource instanceof DataDirectoryResource);
                                        visitor.visit((DataDirectoryResource)dataResource);
                                    }
                                }
                            };
                        }
                        return null;
                    }
                });
                this.programResources.clear();
                this.dataResources.clear();
            }
            return new AndroidApp(ImmutableList.copyOf(this.programResourceProviders), ImmutableMap.copyOf(this.programResourcesMainDescriptor), ImmutableList.copyOf(this.classpathResourceProviders), ImmutableList.copyOf(this.libraryResourceProviders), ImmutableList.copyOf(this.archiveProvidersToClose), this.proguardMapOutputData, this.mainDexListResources, this.mainDexListClasses);
        }

        public Builder addProgramFile(Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                PathOrigin pathOrigin = new PathOrigin(file);
                NoSuchFileException noSuchFileException = new NoSuchFileException(file.toString());
                this.reporter.error(new ExceptionDiagnostic(noSuchFileException, pathOrigin));
            }
            if (FileUtils.isDexFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.DEX, file));
            } else if (FileUtils.isClassFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.CF, file));
            } else if (FileUtils.isArchive(file)) {
                this.addProgramResourceProvider(ArchiveResourceProvider.fromArchive(file, this.ignoreDexInArchive));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
            return this;
        }

        private void addProgramResources(ProgramResource ... resources) {
            this.addProgramResources(Arrays.asList(resources));
        }

        private void addProgramResources(Collection<ProgramResource> resources) {
            this.programResources.addAll(resources);
        }

        private void addDataResources(DataResource ... resources) {
            this.addDataResources(Arrays.asList(resources));
        }

        private void addDataResources(Collection<DataResource> resources) {
            this.dataResources.addAll(resources);
        }

        private void addClasspathOrLibraryProvider(Path file, List<ClassFileResourceProvider> providerList) {
            if (!Files.exists(file, new LinkOption[0])) {
                this.reporter.error(new ExceptionDiagnostic(new NoSuchFileException(file.toString()), new PathOrigin(file)));
            }
            if (FileUtils.isArchive(file)) {
                try {
                    InternalArchiveClassFileProvider provider = new InternalArchiveClassFileProvider(file);
                    this.archiveProvidersToClose.add(provider);
                    providerList.add(provider);
                }
                catch (IOException e) {
                    this.reporter.error(new ExceptionDiagnostic(e, new PathOrigin(file)));
                }
            } else if (Files.isDirectory(file, new LinkOption[0])) {
                providerList.add(DirectoryClassFileProvider.fromDirectory(file));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }

        public List<ProgramResourceProvider> getProgramResourceProviders() {
            return this.programResourceProviders;
        }
    }
}

