package com.example.workmanagerretrybug

import androidx.work.*
import java.util.*
import java.util.concurrent.TimeUnit

class AppWorkHelper(private val workManager: WorkManager) : WorkHelper {

    override suspend fun enqueuePhotoUploadWorker(): UUID {
        workManager.cancelAllWork().await()

        val request: OneTimeWorkRequest = OneTimeWorkRequestBuilder<PhotoUploadWorker>()
                .addTag(WorkHelper.TAG_PHOTO_UPLOAD)
                .setBackoffCriteria(BackoffPolicy.LINEAR, WorkRequest.MIN_BACKOFF_MILLIS, TimeUnit.MILLISECONDS)
                .build()

        workManager.enqueue(request)

        return request.id
    }
}