package com.example.workmanagerretrybug

import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.work.WorkManager
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class MainActivity : AppCompatActivity() {

    private val workHelper: WorkHelper = AppWorkHelper(WorkManager.getInstance())

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        val enqueueButton = findViewById<Button>(R.id.enqueueButton)
        enqueueButton.setOnClickListener {
            GlobalScope.launch {
                val id = workHelper.enqueuePhotoUploadWorker()
                Log.d("MainActivity", "Enqueued work: $id")

                withContext(Dispatchers.Main) {
                    Toast.makeText(this@MainActivity, "Work enqueued", Toast.LENGTH_LONG).show()
                }
            }
        }
    }
}
