package tv.caffeine.mainnavnoimport.start

import android.os.Bundle
import androidx.navigation.NavArgs
import java.lang.IllegalArgumentException
import kotlin.String
import kotlin.jvm.JvmStatic

data class StartFragmentArgs(val param: String) : NavArgs {
    fun toBundle(): Bundle {
        val result = Bundle()
        result.putString("param", this.param)
        return result
    }

    companion object {
        @JvmStatic
        fun fromBundle(bundle: Bundle): StartFragmentArgs {
            bundle.setClassLoader(StartFragmentArgs::class.java.classLoader)
            val __param : String?
            if (bundle.containsKey("param")) {
                __param = bundle.getString("param")
                if (__param == null) {
                    throw IllegalArgumentException("Argument \"param\" is marked as non-null but was passed a null value.")
                }
            } else {
                throw IllegalArgumentException("Required argument \"param\" is missing and does not have an android:defaultValue")
            }
            return StartFragmentArgs(__param)
        }
    }
}
