package com.robotsandpencils.testapp;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.navigation.NavArgs;
import java.io.Serializable;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;

public class GlobalFragmentArgs implements NavArgs {
  private final HashMap arguments = new HashMap();

  private GlobalFragmentArgs() {
  }

  private GlobalFragmentArgs(HashMap argumentsMap) {
    this.arguments.putAll(argumentsMap);
  }

  @NonNull
  @SuppressWarnings("unchecked")
  public static GlobalFragmentArgs fromBundle(@NonNull Bundle bundle) {
    GlobalFragmentArgs __result = new GlobalFragmentArgs();
    bundle.setClassLoader(GlobalFragmentArgs.class.getClassLoader());
    if (bundle.containsKey("ToolbarType")) {
      ToolbarType ToolbarType;
      if (Parcelable.class.isAssignableFrom(ToolbarType.class) || Serializable.class.isAssignableFrom(ToolbarType.class)) {
        ToolbarType = (ToolbarType) bundle.get("ToolbarType");
      } else {
        throw new UnsupportedOperationException(ToolbarType.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
      }
      if (ToolbarType == null) {
        throw new IllegalArgumentException("Argument \"ToolbarType\" is marked as non-null but was passed a null value.");
      }
      __result.arguments.put("ToolbarType", ToolbarType);
    }
    return __result;
  }

  @SuppressWarnings("unchecked")
  @NonNull
  public ToolbarType getToolbarType() {
    return (ToolbarType) arguments.get("ToolbarType");
  }

  @SuppressWarnings("unchecked")
  @NonNull
  public Bundle toBundle() {
    Bundle __result = new Bundle();
    if (arguments.containsKey("ToolbarType")) {
      ToolbarType ToolbarType = (ToolbarType) arguments.get("ToolbarType");
      if (Parcelable.class.isAssignableFrom(ToolbarType.class) || ToolbarType == null) {
        __result.putParcelable("ToolbarType", Parcelable.class.cast(ToolbarType));
      } else if (Serializable.class.isAssignableFrom(ToolbarType.class)) {
        __result.putSerializable("ToolbarType", Serializable.class.cast(ToolbarType));
      } else {
        throw new UnsupportedOperationException(ToolbarType.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
      }
    }
    return __result;
  }

  @Override
  public boolean equals(Object object) {
    if (this == object) {
        return true;
    }
    if (object == null || getClass() != object.getClass()) {
        return false;
    }
    GlobalFragmentArgs that = (GlobalFragmentArgs) object;
    if (arguments.containsKey("ToolbarType") != that.arguments.containsKey("ToolbarType")) {
      return false;
    }
    if (getToolbarType() != null ? !getToolbarType().equals(that.getToolbarType()) : that.getToolbarType() != null) {
      return false;
    }
    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    result = 31 * result + (getToolbarType() != null ? getToolbarType().hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "GlobalFragmentArgs{"
        + "ToolbarType=" + getToolbarType()
        + "}";
  }

  public static class Builder {
    private final HashMap arguments = new HashMap();

    public Builder(GlobalFragmentArgs original) {
      this.arguments.putAll(original.arguments);
    }

    public Builder() {
    }

    @NonNull
    public GlobalFragmentArgs build() {
      GlobalFragmentArgs result = new GlobalFragmentArgs(arguments);
      return result;
    }

    @NonNull
    public Builder setToolbarType(@NonNull ToolbarType ToolbarType) {
      if (ToolbarType == null) {
        throw new IllegalArgumentException("Argument \"ToolbarType\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ToolbarType", ToolbarType);
      return this;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public ToolbarType getToolbarType() {
      return (ToolbarType) arguments.get("ToolbarType");
    }
  }
}
