package com.example.biopromptbug

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.biometric.BiometricPrompt
import androidx.fragment.app.Fragment
import java.util.concurrent.Executors


class Fragment1 : Fragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v = inflater.inflate(R.layout.fragment_one, container, false)
        v.findViewById<View>(R.id.button).setOnClickListener {
            openFragment2()
        }
        v.findViewById<View>(R.id.button2).setOnClickListener {
            openBioMetricsPrompt()
        }
        return v
    }

    private fun openFragment2() {
        val transaction = activity!!.supportFragmentManager
        transaction.beginTransaction()
            .addToBackStack(null)
            .replace(R.id.fragment_container, Fragment2())
            .commit()
    }


    private fun openBioMetricsPrompt() {
        val newExecutor = Executors.newSingleThreadExecutor()
        val biometricPrompt = BiometricPrompt(activity!!, newExecutor, AuthenticationCallback1())

        val promptInfo = BiometricPrompt.PromptInfo.Builder()
            .setTitle("title")
            .setSubtitle("subtitle")
            .setNegativeButtonText("cancel")
            .build()

        biometricPrompt.authenticate(promptInfo)
    }

    class AuthenticationCallback1 : BiometricPrompt.AuthenticationCallback() {

        override fun onAuthenticationError(errorCode: Int, errString: CharSequence) {
            super.onAuthenticationError(errorCode, errString)
            Log.i("Fragment1", "prompt 1 notified")

        }

        override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult) {
            super.onAuthenticationSucceeded(result)
            Log.i("Fragment1", "prompt 1 notified")
        }

        override fun onAuthenticationFailed() {
            super.onAuthenticationFailed()
            Log.i("Fragment1", "prompt 1 notified")
        }
    }


}