package com.example.biopromptbug

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.biometric.BiometricPrompt
import androidx.fragment.app.Fragment
import java.util.concurrent.Executors

class Fragment2 : Fragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        openBioMetricsPrompt2()
        return inflater.inflate(R.layout.fragment_two, container, false)

    }


    private fun openBioMetricsPrompt2() {
        val newExecutor = Executors.newSingleThreadExecutor()
        val biometricPrompt = BiometricPrompt(activity!!, newExecutor, AuthenticationCallback2())

        val promptInfo = BiometricPrompt.PromptInfo.Builder()
            .setTitle("title")
            .setSubtitle("subtitle")
            .setNegativeButtonText("cancel")
            .build()

        biometricPrompt.authenticate(promptInfo)
    }

    class AuthenticationCallback2 : BiometricPrompt.AuthenticationCallback() {

        override fun onAuthenticationError(errorCode: Int, errString: CharSequence) {
            super.onAuthenticationError(errorCode, errString)
            Log.i("Fragment2", "prompt 2 notified")
        }

        override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult) {
            super.onAuthenticationSucceeded(result)
            Log.i("Fragment2", "prompt 2 notified")
        }

        override fun onAuthenticationFailed() {
            super.onAuthenticationFailed()
            Log.i("Fragment2", "prompt 2 notified")
        }
    }

}