package com.perracolabs.workmanagerbug;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import androidx.work.BackoffPolicy;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;

final class BugTest
{
    private static final int ITERATIONS = 20;

    private static final Executor executor = Executors.newFixedThreadPool(4);

    static void reset()
    {
        BugTest.submit(ExistingWorkPolicy.REPLACE);
    }

    static void start(final boolean crash)
    {
        for (int index = BugTest.ITERATIONS; index > 0; index--)
        {
            BugTest.submit(ExistingWorkPolicy.APPEND);

            if ((index > (BugTest.ITERATIONS / 2)) && (crash == true))
            {
                throw new RuntimeException("Forced crash.");
            }
        }
    }

    private static void submit(final ExistingWorkPolicy policy)
    {
        final Runnable runnable = new Runnable()
        {
            @Override
            public void run()
            {
                final Data.Builder workDataBuilder = new Data.Builder();

                workDataBuilder.putLong(WorkerTest.KEY_TIMESTAMP, System.nanoTime());

                final OneTimeWorkRequest request = new OneTimeWorkRequest.Builder(WorkerTest.class)
                        .setInputData(workDataBuilder.build())
                        .setBackoffCriteria(BackoffPolicy.LINEAR, WorkRequest.MIN_BACKOFF_MILLIS, TimeUnit.MILLISECONDS)
                        .keepResultsForAtLeast(1, TimeUnit.MINUTES)
                        .build();

                final WorkManager workManager = WorkManager.getInstance();

                // The problem also happens if using instead beginUniqueWork()
                workManager.enqueueUniqueWork(WorkerTest.WORK_NAME, policy, request);
            }
        };

        BugTest.executor.execute(runnable);
    }
}
