package com.perracolabs.workmanagerbug;

import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import java.util.List;

import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;

public class MainActivity extends AppCompatActivity implements View.OnClickListener, Observer<List<WorkInfo>>
{
    @Override
    protected void onCreate(final Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        this.setContentView(R.layout.content_main);

        this.findViewById(R.id.start).setOnClickListener(this);
        this.findViewById(R.id.reset).setOnClickListener(this);

        final WorkManager workManager = WorkManager.getInstance();

        final LiveData<List<WorkInfo>> liveData = workManager.getWorkInfosForUniqueWorkLiveData(WorkerTest.WORK_NAME);

        liveData.observe(this, this);
    }

    @Override
    public void onClick(final View view)
    {
        final TextView output = this.findViewById(R.id.status);
        output.setText("Wait till the LiveData logs appear");

        final WorkManager workManager = WorkManager.getInstance();
        // Yes, bad to do. Only pruning to have clean logs in the test
        workManager.pruneWork();

        final int id = view.getId();

        if (id == R.id.start)
        {
            final boolean crash = ((CheckBox)this.findViewById(R.id.crash_check)).isChecked();
            BugTest.start(crash);
        }
        else
        {
            BugTest.reset();
        }
    }

    @Override
    public void onChanged(final List<WorkInfo> workInfoList)
    {
        int enqueued  = 0;
        int blocked   = 0;
        int failed    = 0;
        int running   = 0;
        int cancelled = 0;

        for (final WorkInfo entry : workInfoList)
        {
            final WorkInfo.State state = entry.getState();

            switch (state)
            {
                case ENQUEUED:
                    enqueued++;
                    break;

                case RUNNING:
                    running++;
                    break;

                case BLOCKED:
                    blocked++;
                    break;

                case FAILED:
                    failed++;
                    break;

                case CANCELLED:
                    cancelled++;
                    break;
            }
        }

        final String output = "enqueued: " + enqueued
                + '\n' + "running: " + running
                + '\n' + "blocked: " + blocked
                + '\n' + "failed: " + failed
                + '\n' + "cancelled: " + cancelled;

        ((TextView)this.findViewById(R.id.status)).setText(output);
    }
}
