package com.perracolabs.workmanagerbug;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

public final class WorkerTest extends Worker
{
    static final String WORK_NAME = "TheWorkName";

    static final String KEY_TIMESTAMP = "t";

    public WorkerTest(@NonNull final Context context, @NonNull final WorkerParameters workerParameters)
    {
        super(context, workerParameters);
    }

    @NonNull
    @Override
    public ListenableWorker.Result doWork()
    {
        final int attempt = this.getRunAttemptCount();

        if (attempt > 0)
        {
            Log.i(WorkerTest.WORK_NAME,"Run attempt" + String.valueOf(attempt));
        }

        try
        {
            final Data workData  = this.getInputData();
            final Long timestamp = workData.getLong(WorkerTest.KEY_TIMESTAMP, 0L);

            Log.i(WorkerTest.WORK_NAME, String.valueOf(timestamp));

            // Sleep for a moment to simulate doing some work
            Thread.sleep(5L);
        }
        catch (InterruptedException e)
        {
            e.printStackTrace();
        }

        return ListenableWorker.Result.success();
    }
}
