package ch.liip.issue126612680

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProviders
import kotlinx.android.synthetic.main.activity_main.*
import androidx.core.view.*

class MainActivity : AppCompatActivity() {

    private lateinit var viewModel: MainViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        viewModel = ViewModelProviders.of(this).get(MainViewModel::class.java)

        setObservers()

        setListeners()
    }

    private fun setListeners() {
        click_button.setOnClickListener {
            viewModel.clicked()
        }

        an_image.setOnClickListener {image->
            image.isVisible = !image.isVisible
        }
    }

    private fun setObservers() {
        viewModel.nbClicks.observe(this, Observer { nbClicks ->
            click_textview.text = resources.getString(R.string.click_text, nbClicks)
        })
    }
}
