package com.mikescamell.fragmentcrashtest

import android.os.Bundle
import androidx.annotation.ContentView
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import androidx.navigation.ui.NavigationUI
import kotlinx.android.synthetic.main.main_activity.*

class MainActivity : AppCompatActivity() {

    private lateinit var navController: NavController

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.main_activity)

        val host: NavHostFragment = supportFragmentManager
            .findFragmentById(R.id.navigationHostFragment) as NavHostFragment? ?: return

        navController = host.navController

        NavigationUI.setupWithNavController(bottomNavigation, navController)
    }

}
