package com.topjohnwu.retrostreams;

import androidx.appcompat.app.AppCompatActivity;
import androidx.collection.ArraySet;

import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

import java9.util.Comparators;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

public class MainActivity extends AppCompatActivity {

    private PackageManager pm;
    private List<HideAppInfo> fullList = new ArrayList<>();

    private void addProcesses(Set<String> set, ComponentInfo[] infos) {
        if (infos != null)
            for (ComponentInfo info : infos)
                set.add(info.processName);
    }

    private PackageInfo getPackageInfo(String pkg) {
        try {
            return pm.getPackageInfo(pkg,
                    PackageManager.GET_ACTIVITIES | PackageManager.GET_SERVICES |
                    PackageManager.GET_RECEIVERS | PackageManager.GET_PROVIDERS);
        } catch (Exception e1) {
            try {
                PackageInfo info = pm.getPackageInfo(pkg, PackageManager.GET_ACTIVITIES);
                info.services = pm.getPackageInfo(pkg, PackageManager.GET_SERVICES).services;
                info.receivers = pm.getPackageInfo(pkg, PackageManager.GET_RECEIVERS).receivers;
                info.providers = pm.getPackageInfo(pkg, PackageManager.GET_PROVIDERS).providers;
                return info;
            } catch (Exception e2) {
                return null;
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        pm = getPackageManager();

        List<ApplicationInfo> installed = pm.getInstalledApplications(0);

        fullList.clear();

        for (ApplicationInfo info : installed) {
            // Do not show black-listed and disabled apps
            if (info.enabled) {
                Set<String> set = new ArraySet<>();
                PackageInfo pkg = getPackageInfo(info.packageName);
                if (pkg != null) {
                    addProcesses(set, pkg.activities);
                    addProcesses(set, pkg.services);
                    addProcesses(set, pkg.receivers);
                    addProcesses(set, pkg.providers);
                } else {
                    set.add(info.packageName);
                }
                fullList.addAll(StreamSupport.stream(set)
                        .map(process -> new HideAppInfo(info, process))
                        .collect(Collectors.toList()));
            }
        }
    }

    class HideAppInfo implements Comparable<HideAppInfo> {
        String process;
        String name;
        ApplicationInfo info;
        boolean hidden;

        HideAppInfo(ApplicationInfo info, String process) {
            this.process = process;
            this.info = info;
            name = pm.getApplicationLabel(info).toString();
        }

        @Override
        public int compareTo(HideAppInfo o) {
            Comparator<HideAppInfo> c;
            c = Comparators.comparing((HideAppInfo t) -> t.hidden);
            c = Comparators.reversed(c);
            c = Comparators.thenComparing(c, t -> t.name, String::compareToIgnoreCase);
            c = Comparators.thenComparing(c, t -> t.info.packageName);
            c = Comparators.thenComparing(c, t -> t.process);
            return c.compare(this, o);
        }
    }
}
