package com.example.fragmenttest;

import android.os.Bundle;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

public class MainActivity extends AppCompatActivity {

    private String currentBackstackTag;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        findViewById(R.id.red).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                switchFragments("Red", "RED", new RedFragment());
            }
        });

        findViewById(R.id.blue).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                switchFragments("Blue", "BLUE", new BlueFragment());
            }
        });

        findViewById(R.id.green).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                switchFragments("Green", "GREEN", new GreenFragment());
            }
        });
    }

    private void switchFragments(String tag, String backstackTag, Fragment fragment) {
        FragmentManager fm = getSupportFragmentManager();
        Fragment currentFragment = fm.findFragmentById(R.id.fragment_container);

        if (currentFragment != null) {
            fm.popBackStackImmediate(currentBackstackTag, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
        currentBackstackTag = backstackTag;

        FragmentTransaction txn = fm.beginTransaction();

        if (fragment instanceof GreenFragment) {
            txn.setCustomAnimations(
                    R.anim.slide_in_bottom_with_fade,
                    R.anim.abc_fade_out,
                    R.anim.abc_fade_in,
                    R.anim.abc_fade_out);
        } else if (fragment instanceof BlueFragment) {
            txn.setCustomAnimations(
                    R.anim.abc_grow_fade_in_from_bottom,
                    R.anim.abc_fade_out,
                    R.anim.abc_fade_in,
                    R.anim.abc_shrink_fade_out_from_bottom);
        } else {
            // When changing tabs, use a custom scale/fade in/out animation.
            txn.setCustomAnimations(R.anim.bottom_tab_fade_in, R.anim.bottom_tab_fade_out);
        }


        txn.replace(R.id.fragment_container, fragment, tag);
        txn.addToBackStack(backstackTag);

        Bundle args = fragment.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        fragment.setArguments(args);

        txn.commit();
    }
}
