//
//  Annotation.swift
//  GoogleMapsTest
//
//  Created by Andrey Lisovskiy on 4/2/19.
//  Copyright © 2019 Andrey Lisovskiy. All rights reserved.
//

import UIKit

extension UIView {
    class func initFromNib<T: UIView>() -> T {
        return Bundle.main.loadNibNamed(String(describing: self), owner: nil, options: nil)?[0] as! T
    }
}

class Annotation: UIView {
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var descriptionLabel: UILabel!
    
    func configure(with title: String, subtitle: String) {
        titleLabel.text = title
        descriptionLabel.text = subtitle
        
        accessibilityLabel = title
        accessibilityValue = subtitle
    }
}
