//
//  ViewController.swift
//  GoogleMapsTest
//
//  Created by Andrey Lisovskiy on 4/2/19.
//  Copyright © 2019 Andrey Lisovskiy. All rights reserved.
//

import UIKit
import GoogleMaps

class ViewController: UIViewController, GMSMapViewDelegate {

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
    }

    override func loadView() {
        let camera = GMSCameraPosition.camera(withLatitude: -33.86, longitude: 151.20, zoom: 6.0)
        let mapView = GMSMapView.map(withFrame: CGRect.zero, camera: camera)
        mapView.accessibilityElementsHidden = false
        mapView.delegate = self

        view = mapView
        
        let marker = GMSMarker()
        marker.position = CLLocationCoordinate2D(latitude: -33.86, longitude: 151.20)
        marker.map = mapView
        
//        marker.accessibilityLabel = "Sydney"
//        marker.accessibilityValue = "Sydney is the state capital of New South Wales"
    }
    
    //MARK: - GMSMapViewDelegate
    func mapView(_ mapView: GMSMapView, markerInfoContents marker: GMSMarker) -> UIView? {
        let view: Annotation = Annotation.initFromNib()
        view.configure(with: "Sydney", subtitle: "Sydney is the state capital of New South Wales")
        view.frame = CGRect(x: 0, y: 0, width: 250, height: 100)
        
        return view
    }
}

