package com.dhabensky.viewmodelleak

import androidx.lifecycle.Lifecycle
import androidx.test.core.app.ActivityScenario
import org.junit.Test

/**
 * Created on 31.03.2019.
 * @author dhabensky <dhabensky@yandex.ru>
 */
class ViewModelLeakInstrumentationTest {

    @Test
    fun test() {
        val scenario = ActivityScenario.launch(TestActivity::class.java)
        scenario
            .onActivity {
                it.supportFragmentManager
                    .beginTransaction()
                    .add(MasterFragment(), null)
                    .commit()
            }
            .moveToState(Lifecycle.State.RESUMED)
            .onActivity {
                val childFragmentManager = it
                    .supportFragmentManager
                    .fragments[0]
                    .childFragmentManager

                childFragmentManager
                    .beginTransaction()
                    .add(R.id.master_fragment_root, NestedFragmentWithViewModel())
                    .addToBackStack("nested 1")
                    .commit()
            }
            .onActivity {
                val childFragmentManager = it
                    .supportFragmentManager
                    .fragments[0]
                    .childFragmentManager

                childFragmentManager
                    .beginTransaction()
                    .replace(R.id.master_fragment_root, NestedFragment())
                    .addToBackStack("nested 2")
                    .commit()
            }
            .apply {
                println("\nrecreating")
                recreate()
                println("recreated")
            }
            .apply {
                println("\ndestroying")
                moveToState(Lifecycle.State.DESTROYED)
                println("destroyed")
            }
    }

}
