package com.dhabensky.viewmodelleak

import androidx.lifecycle.Lifecycle
import androidx.test.core.app.ActivityScenario
import org.junit.Test
import org.junit.runner.RunWith
import org.robolectric.RobolectricTestRunner
import org.robolectric.annotation.Config

/**
 * Created on 31.03.2019.
 * @author dhabensky <dhabensky@yandex.ru>
 */
@RunWith(RobolectricTestRunner::class)
@Config(sdk = [21])
class ViewModelLeakTest {

    @Test
    fun test() {
        val scenario = ActivityScenario.launch(TestActivity::class.java)
        scenario
            .onActivity {
                it.supportFragmentManager
                    .beginTransaction()
                    .add(MasterFragment(), null)
                    .commit()
            }
            .moveToState(Lifecycle.State.RESUMED)
            .onActivity {
                val childFragmentManager = it
                    .supportFragmentManager
                    .fragments[0]
                    .childFragmentManager

                childFragmentManager
                    .beginTransaction()
                    .add(R.id.master_fragment_root, NestedFragmentWithViewModel())
                    .addToBackStack("nested 1")
                    .commit()
            }
            .onActivity {
                val childFragmentManager = it
                    .supportFragmentManager
                    .fragments[0]
                    .childFragmentManager

                childFragmentManager
                    .beginTransaction()
                    .replace(R.id.master_fragment_root, NestedFragment())
                    .addToBackStack("nested 2")
                    .commit()
            }
            .apply {
                println("\nrecreating")
                recreate()
                println("recreated")
            }
            .apply {
                println("\ndestroying")
                moveToState(Lifecycle.State.DESTROYED)
                println("destroyed")
            }
    }

}
