package com.commonsware.todo.repo

import android.app.Application
import androidx.arch.core.executor.testing.InstantTaskExecutorRule
import androidx.test.core.app.ApplicationProvider
import androidx.test.ext.junit.runners.AndroidJUnit4
import com.commonsware.todo.ui.display.DisplayMotor
import com.google.common.truth.Truth.assertThat
import kotlinx.coroutines.runBlocking
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith
import org.koin.android.ext.koin.with
import org.koin.standalone.StandAloneContext.loadKoinModules
import org.koin.standalone.StandAloneContext.stopKoin
import org.koin.standalone.inject
import org.koin.test.KoinTest

@RunWith(AndroidJUnit4::class)
class DisplayMotorTest : KoinTest {
  @get:Rule
  var taskRule = InstantTaskExecutorRule()

  private val repo: ToDoRepository by inject()

  @Before
  fun setUp() {
    stopKoin()
    loadKoinModules(testModule) with ApplicationProvider.getApplicationContext<Application>()
  }

  @Test
  fun basics() {
    assertThat(repo.all().blockingValue).isEmpty()

    val firstModel = ToDoModel(
      description = "Buy a copy of _Exploring Android_",
      notes = "See https://wares.commonsware.com",
      isCompleted = true
    )

    runBlocking { repo.insert(firstModel) }

    assertThat(repo.all().blockingValue).containsExactly(firstModel)

    val underTest = DisplayMotor(repo, firstModel.id)

    assertThat(underTest.states.blockingValue?.item).isEqualTo(firstModel)
  }
}
