package com.commonsware.todo.repo

import androidx.lifecycle.LiveData
import androidx.lifecycle.Observer
import java.util.concurrent.CountDownLatch
import java.util.concurrent.TimeUnit

// inspired by https://gist.github.com/arekolek/e9e0d050cdd6ed16cd7dd9183eee62c0
// requires InstantTaskExecutorRule!

val <T> LiveData<T>.blockingValue: T?
  get() {
    var value: T? = null
    val latch = CountDownLatch(1)
    val observer = Observer<T> {
      value = it
      latch.countDown()
    }

    observeForever(observer)

    try {
      if (latch.await(2, TimeUnit.SECONDS)) {
        return value
      } else {
        throw Exception("LiveData value was not set within 2 seconds")
      }
    } finally {
      removeObserver(observer)
    }
  }