package com.commonsware.todo

import android.app.Application
import com.commonsware.todo.repo.ToDoDatabase
import com.commonsware.todo.repo.ToDoRepository
import com.commonsware.todo.ui.display.DisplayMotor
import com.commonsware.todo.ui.edit.EditMotor
import com.commonsware.todo.ui.roster.RosterMotor
import org.koin.android.ext.android.startKoin
import org.koin.android.ext.koin.androidApplication
import org.koin.androidx.viewmodel.ext.koin.viewModel
import org.koin.dsl.module.module

private val KOIN_MODULE = module {
  single { ToDoDatabase.newInstance(androidApplication()) }
  single { ToDoRepository(get()) }
  viewModel { RosterMotor(get()) }
  viewModel { (id: String) -> DisplayMotor(get(), id) }
  viewModel { (id: String?) -> EditMotor(get(), id) }
}

class ToDoApp : Application() {
  override fun onCreate() {
    super.onCreate()

    startKoin(this, listOf(KOIN_MODULE))
  }
}