package com.commonsware.todo.repo

import android.app.Application
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters

private const val DB_NAME = "stuff.db"

@Database(entities = [ToDoEntity::class], version = 1)
@TypeConverters(TypeTransmogrifier::class)
abstract class ToDoDatabase : RoomDatabase() {
  abstract fun todoStore(): ToDoEntity.Store

  companion object {
    fun newInstance(
      app: Application,
      memoryOnly: Boolean = false
    ) =
      if (memoryOnly) {
        Room.inMemoryDatabaseBuilder(app, ToDoDatabase::class.java)
      } else {
        Room.databaseBuilder(app, ToDoDatabase::class.java, DB_NAME)
      }.build()
  }
}
