package com.commonsware.todo.repo

import androidx.recyclerview.widget.DiffUtil
import java.util.*

data class ToDoModel(
  val description: String = "",
  val id: String = UUID.randomUUID().toString(),
  val isCompleted: Boolean = false,
  val notes: String = "",
  val createdOn: Calendar = Calendar.getInstance()
) {
  companion object {
    fun filter(
      models: List<ToDoModel>,
      filterMode: FilterMode
    ): List<ToDoModel> {
      val result: MutableList<ToDoModel>

      if (filterMode === FilterMode.COMPLETED) {
        result = ArrayList()

        for (model in models) {
          if (model.isCompleted) {
            result.add(model)
          }
        }
      } else if (filterMode === FilterMode.OUTSTANDING) {
        result = ArrayList()

        for (model in models) {
          if (!model.isCompleted) {
            result.add(model)
          }
        }
      } else {
        result = ArrayList(models)
      }

      return Collections.unmodifiableList(result)
    }
  }

  object DiffCallback : DiffUtil.ItemCallback<ToDoModel>() {
    override fun areItemsTheSame(oldItem: ToDoModel, newItem: ToDoModel) =
      oldItem === newItem

    override fun areContentsTheSame(oldItem: ToDoModel, newItem: ToDoModel) =
      oldItem.isCompleted == newItem.isCompleted &&
          oldItem.description == newItem.description
  }
}
