package com.commonsware.todo.repo

import androidx.lifecycle.Transformations

class ToDoRepository(db: ToDoDatabase) {
  private val store = db.todoStore()

  fun all() =
    Transformations.map(store.all()) { all -> all.map { it.toModel() } }

  fun forId(id: String) = Transformations.map(store.forId(id)) { it.toModel() }

  suspend fun save(model: ToDoModel) {
    store.save(ToDoEntity(model))
  }

  suspend fun delete(model: ToDoModel) {
    store.delete(ToDoEntity(model))
  }
}